/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.trino.spi.metrics.Metrics;
import java.util.List;
import java.util.Objects;

class BasicOperatorStats {
    private final long totalDrivers;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final Metrics metrics;
    private final Metrics connectorMetrics;

    public BasicOperatorStats(long totalDrivers, long inputPositions, double sumSquaredInputPositions, Metrics metrics, Metrics connectorMetrics) {
        this.totalDrivers = totalDrivers;
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.connectorMetrics = Objects.requireNonNull(connectorMetrics, "connectorMetrics is null");
    }

    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    public long getInputPositions() {
        return this.inputPositions;
    }

    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Metrics getConnectorMetrics() {
        return this.connectorMetrics;
    }

    public static BasicOperatorStats merge(BasicOperatorStats first, BasicOperatorStats second) {
        return new BasicOperatorStats(first.totalDrivers + second.totalDrivers, first.inputPositions + second.inputPositions, first.sumSquaredInputPositions + second.sumSquaredInputPositions, first.metrics.mergeWith(second.metrics), first.connectorMetrics.mergeWith(second.connectorMetrics));
    }

    public static BasicOperatorStats merge(List<BasicOperatorStats> operatorStats) {
        long totalDrivers = 0L;
        long inputPositions = 0L;
        double sumSquaredInputPositions = 0.0;
        Metrics.Accumulator metricsAccumulator = Metrics.accumulator();
        Metrics.Accumulator connectorMetricsAccumulator = Metrics.accumulator();
        for (BasicOperatorStats stats : operatorStats) {
            totalDrivers += stats.totalDrivers;
            inputPositions += stats.inputPositions;
            sumSquaredInputPositions += stats.sumSquaredInputPositions;
            metricsAccumulator.add(stats.metrics);
            connectorMetricsAccumulator.add(stats.connectorMetrics);
        }
        return new BasicOperatorStats(totalDrivers, inputPositions, sumSquaredInputPositions, metricsAccumulator.get(), connectorMetricsAccumulator.get());
    }
}

