/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MergeProcessorNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.MergeTarget target;
    private final Symbol rowIdSymbol;
    private final Symbol mergeRowSymbol;
    private final List<Symbol> dataColumnSymbols;
    private final List<Symbol> redistributionColumnSymbols;
    private final List<Symbol> outputs;

    @JsonCreator
    public MergeProcessorNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.MergeTarget target, @JsonProperty(value="rowIdSymbol") Symbol rowIdSymbol, @JsonProperty(value="mergeRowSymbol") Symbol mergeRowSymbol, @JsonProperty(value="dataColumnSymbols") List<Symbol> dataColumnSymbols, @JsonProperty(value="redistributionColumnSymbols") List<Symbol> redistributionColumnSymbols, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.mergeRowSymbol = Objects.requireNonNull(mergeRowSymbol, "mergeRowSymbol is null");
        this.rowIdSymbol = Objects.requireNonNull(rowIdSymbol, "rowIdSymbol is null");
        this.dataColumnSymbols = Objects.requireNonNull(dataColumnSymbols, "dataColumnSymbols is null");
        this.redistributionColumnSymbols = Objects.requireNonNull(redistributionColumnSymbols, "redistributionColumnSymbols is null");
        this.outputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.MergeTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getMergeRowSymbol() {
        return this.mergeRowSymbol;
    }

    @JsonProperty
    public Symbol getRowIdSymbol() {
        return this.rowIdSymbol;
    }

    @JsonProperty
    public List<Symbol> getDataColumnSymbols() {
        return this.dataColumnSymbols;
    }

    @JsonProperty
    public List<Symbol> getRedistributionColumnSymbols() {
        return this.redistributionColumnSymbols;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeProcessor(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MergeProcessorNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowIdSymbol, this.mergeRowSymbol, this.dataColumnSymbols, this.redistributionColumnSymbols, this.outputs);
    }
}

