/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.util.MoreLists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final Scope scope;
    private final List<PlanNode> sources;
    private final PartitioningScheme partitioningScheme;
    private final List<List<Symbol>> inputs;
    private final Optional<OrderingScheme> orderingScheme;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="inputs") List<List<Symbol>> inputs, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        Preconditions.checkArgument((!inputs.isEmpty() ? 1 : 0) != 0, (Object)"inputs is empty");
        Preconditions.checkArgument((boolean)inputs.stream().allMatch(inputSymbols -> inputSymbols.size() == partitioningScheme.getOutputLayout().size()), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((inputs.size() == sources.size() ? 1 : 0) != 0, (Object)"Must have same number of input lists as sources");
        for (int i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)ImmutableSet.copyOf(sources.get(i).getOutputSymbols()).containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input symbols");
        }
        Preconditions.checkArgument((scope != Scope.LOCAL || partitioningScheme.getPartitioning().getArguments().stream().allMatch(Partitioning.ArgumentBinding::isVariable) ? 1 : 0) != 0, (Object)"local exchanges do not support constant partition function arguments");
        Preconditions.checkArgument((scope != Scope.REMOTE || type == Type.REPARTITION || !partitioningScheme.isReplicateNullsAndAny() ? 1 : 0) != 0, (Object)"Only REPARTITION can replicate remotely");
        orderingScheme.ifPresent(ordering -> {
            PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
            Preconditions.checkArgument((scope != Scope.REMOTE || partitioningHandle.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (Object)"remote merging exchange requires single distribution");
            Preconditions.checkArgument((scope != Scope.LOCAL || partitioningHandle.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION) ? 1 : 0) != 0, (Object)"local merging exchange requires passthrough distribution");
            Preconditions.checkArgument((boolean)partitioningScheme.getOutputLayout().containsAll(ordering.orderBy()), (Object)"Partitioning scheme does not supply all required ordering symbols");
            Preconditions.checkArgument((type == Type.GATHER ? 1 : 0) != 0, (Object)"Merging exchange must be of GATHER type");
            Preconditions.checkArgument((inputs.size() == 1 ? 1 : 0) != 0, (Object)"Merging exchange must have single input");
        });
        this.type = type;
        this.sources = sources;
        this.scope = scope;
        this.partitioningScheme = partitioningScheme;
        this.inputs = MoreLists.listOfListsCopy(inputs);
        this.orderingScheme = orderingScheme;
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<Symbol> partitioningColumns, Optional<Symbol> hashColumns) {
        return ExchangeNode.partitionedExchange(id, scope, child, partitioningColumns, hashColumns, false);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<Symbol> partitioningColumns, Optional<Symbol> hashColumns, boolean replicateNullsAndAny) {
        return ExchangeNode.partitionedExchange(id, scope, child, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitioningColumns), child.getOutputSymbols(), hashColumns, replicateNullsAndAny, Optional.empty(), Optional.empty()));
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, PartitioningScheme partitioningScheme) {
        if (partitioningScheme.getPartitioning().getHandle().isSingleNode()) {
            return ExchangeNode.gatheringExchange(id, scope, child);
        }
        return new ExchangeNode(id, Type.REPARTITION, scope, partitioningScheme, (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(partitioningScheme.getOutputLayout()), Optional.empty());
    }

    public static ExchangeNode replicatedExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.REPLICATE, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()), Optional.empty());
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()), Optional.empty());
    }

    public static ExchangeNode roundRobinExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return ExchangeNode.partitionedExchange(id, scope, child, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()));
    }

    public static ExchangeNode mergingExchange(PlanNodeId id, Scope scope, PlanNode child, OrderingScheme orderingScheme) {
        PartitioningHandle partitioningHandle = scope == Scope.LOCAL ? SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION : SystemPartitioningHandle.SINGLE_DISTRIBUTION;
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(partitioningHandle, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()), Optional.of(orderingScheme));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.partitioningScheme.getOutputLayout();
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExchangeNode(this.getId(), this.type, this.scope, this.partitioningScheme, newChildren, this.inputs, this.orderingScheme);
    }

    public static enum Scope {
        LOCAL,
        REMOTE;

    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

