/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;

public class Assignments {
    private final Map<Symbol, Expression> assignments;

    public static Builder builder() {
        return new Builder();
    }

    public static Assignments identity(Symbol ... symbols) {
        return Assignments.identity(Arrays.asList(symbols));
    }

    public static Assignments identity(Iterable<Symbol> symbols) {
        return Assignments.builder().putIdentities(symbols).build();
    }

    public static Assignments copyOf(Map<Symbol, Expression> assignments) {
        return Assignments.builder().putAll(assignments).build();
    }

    public static Assignments of() {
        return Assignments.builder().build();
    }

    public static Assignments of(Symbol symbol, Expression expression) {
        return Assignments.builder().put(symbol, expression).build();
    }

    public static Assignments of(Symbol symbol1, Expression expression1, Symbol symbol2, Expression expression2) {
        return Assignments.builder().put(symbol1, expression1).put(symbol2, expression2).build();
    }

    public static Assignments of(Collection<? extends Expression> expressions, SymbolAllocator symbolAllocator) {
        Builder assignments = Assignments.builder();
        for (Expression expression : expressions) {
            assignments.put(symbolAllocator.newSymbol(expression), expression);
        }
        return assignments.build();
    }

    @JsonCreator
    public Assignments(@JsonProperty(value="assignments") Map<Symbol, Expression> assignments) {
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
    }

    public List<Symbol> getOutputs() {
        return ImmutableList.copyOf(this.assignments.keySet());
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, Expression> getMap() {
        return this.assignments;
    }

    public Assignments rewrite(Function<Expression, Expression> rewrite) {
        return this.assignments.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((Symbol)entry.getKey()), (Object)((Expression)rewrite.apply((Expression)entry.getValue())))).collect(this.toAssignments());
    }

    public Assignments filter(Collection<Symbol> symbols) {
        return this.filter(symbols::contains);
    }

    public Assignments filter(Predicate<Symbol> predicate) {
        return this.assignments.entrySet().stream().filter((? super T entry) -> predicate.test((Symbol)entry.getKey())).collect(this.toAssignments());
    }

    public boolean isIdentity(Symbol output) {
        Expression expression = this.assignments.get(output);
        return expression instanceof Reference && ((Reference)expression).name().equals(output.name());
    }

    public boolean isIdentity() {
        for (Map.Entry<Symbol, Expression> entry : this.assignments.entrySet()) {
            Expression expression = entry.getValue();
            Symbol symbol = entry.getKey();
            if (expression instanceof Reference && ((Reference)expression).name().equals(symbol.name())) continue;
            return false;
        }
        return true;
    }

    private Collector<Map.Entry<Symbol, Expression>, Builder, Assignments> toAssignments() {
        return Collector.of(Assignments::builder, (builder, entry) -> builder.put((Symbol)entry.getKey(), (Expression)entry.getValue()), (left, right) -> {
            left.putAll(right.build());
            return left;
        }, Builder::build, new Collector.Characteristics[0]);
    }

    public Collection<Expression> getExpressions() {
        return this.assignments.values();
    }

    public Set<Symbol> getSymbols() {
        return this.assignments.keySet();
    }

    public Set<Map.Entry<Symbol, Expression>> entrySet() {
        return this.assignments.entrySet();
    }

    public Expression get(Symbol symbol) {
        return this.assignments.get(symbol);
    }

    public int size() {
        return this.assignments.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void forEach(BiConsumer<Symbol, Expression> consumer) {
        this.assignments.forEach(consumer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignments that = (Assignments)o;
        return this.assignments.equals(that.assignments);
    }

    public int hashCode() {
        return this.assignments.hashCode();
    }

    public static class Builder {
        private final Map<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();

        public Builder putAll(Assignments assignments) {
            return this.putAll(assignments.getMap());
        }

        public Builder putAll(Map<Symbol, ? extends Expression> assignments) {
            for (Map.Entry<Symbol, ? extends Expression> assignment : assignments.entrySet()) {
                this.put(assignment.getKey(), assignment.getValue());
            }
            return this;
        }

        public Builder put(Symbol symbol, Expression expression) {
            Preconditions.checkArgument((boolean)symbol.type().equals((Object)expression.type()), (String)"Types don't match: %s vs %s, for %s and %s", (Object)symbol.type(), (Object)expression.type(), (Object)symbol, (Object)expression);
            if (this.assignments.containsKey(symbol)) {
                Expression assignment = this.assignments.get(symbol);
                Preconditions.checkState((boolean)assignment.equals(expression), (String)"Symbol %s already has assignment %s, while adding %s", (Object)symbol.name(), (Object)assignment, (Object)expression);
            }
            this.assignments.put(symbol, expression);
            return this;
        }

        public Builder put(Map.Entry<Symbol, Expression> assignment) {
            this.put(assignment.getKey(), assignment.getValue());
            return this;
        }

        public Builder putIdentities(Iterable<Symbol> symbols) {
            for (Symbol symbol : symbols) {
                this.putIdentity(symbol);
            }
            return this;
        }

        public Builder putIdentity(Symbol symbol) {
            this.put(symbol, symbol.toSymbolReference());
            return this;
        }

        public Assignments build() {
            return new Assignments(this.assignments);
        }

        public Builder add(Assignment assignment) {
            this.put(assignment.getOutput(), assignment.getExpression());
            return this;
        }
    }

    public static class Assignment {
        private final Symbol output;
        private final Expression expression;

        public Assignment(Symbol output, Expression expression) {
            this.output = Objects.requireNonNull(output, "output is null");
            this.expression = Objects.requireNonNull(expression, "expression is null");
        }

        public Symbol getOutput() {
            return this.output;
        }

        public Expression getExpression() {
            return this.expression;
        }
    }
}

