/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.CostComparator;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughJoin;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ReorderJoins
implements Rule<JoinNode> {
    private static final Logger log = Logger.get(ReorderJoins.class);
    private final Pattern<JoinNode> pattern;
    private final PlannerContext plannerContext;
    private final CostComparator costComparator;

    public ReorderJoins(PlannerContext plannerContext, CostComparator costComparator) {
        this.plannerContext = plannerContext;
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.pattern = Patterns.join().matching(joinNode -> joinNode.getDistributionType().isEmpty() && joinNode.getType() == JoinType.INNER && DeterminismEvaluator.isDeterministic(joinNode.getFilter().orElse(Booleans.TRUE)));
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.getJoinReorderingStrategy(session) == OptimizerConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        MultiJoinNode multiJoinNode = MultiJoinNode.toMultiJoinNode(joinNode, context, true);
        JoinEnumerationResult resultWithProjectionPushdown = this.chooseJoinOrder(multiJoinNode, context);
        if (resultWithProjectionPushdown.getPlanNode().isEmpty()) {
            return Rule.Result.empty();
        }
        if (!multiJoinNode.isPushedProjectionThroughJoin()) {
            return Rule.Result.ofPlanNode(resultWithProjectionPushdown.getPlanNode().get());
        }
        multiJoinNode = MultiJoinNode.toMultiJoinNode(joinNode, context, false);
        JoinEnumerationResult resultWithoutProjectionPushdown = this.chooseJoinOrder(multiJoinNode, context);
        if (resultWithoutProjectionPushdown.getPlanNode().isEmpty() || this.costComparator.compare(context.getSession(), resultWithProjectionPushdown.cost, resultWithoutProjectionPushdown.cost) < 0) {
            return Rule.Result.ofPlanNode(resultWithProjectionPushdown.getPlanNode().get());
        }
        return Rule.Result.ofPlanNode(resultWithoutProjectionPushdown.getPlanNode().get());
    }

    private JoinEnumerationResult chooseJoinOrder(MultiJoinNode multiJoinNode, Rule.Context context) {
        JoinEnumerator joinEnumerator = new JoinEnumerator(this.costComparator, multiJoinNode.getFilter(), context, this.plannerContext);
        return joinEnumerator.choose(multiJoinNode.getSources(), multiJoinNode.getOutputSymbols());
    }

    @VisibleForTesting
    static class MultiJoinNode {
        private final LinkedHashSet<PlanNode> sources;
        private final Expression filter;
        private final List<Symbol> outputSymbols;
        private final boolean pushedProjectionThroughJoin;

        MultiJoinNode(LinkedHashSet<PlanNode> sources, Expression filter, List<Symbol> outputSymbols, boolean pushedProjectionThroughJoin) {
            Objects.requireNonNull(sources, "sources is null");
            Preconditions.checkArgument((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is <= 1");
            Objects.requireNonNull(filter, "filter is null");
            Objects.requireNonNull(outputSymbols, "outputSymbols is null");
            this.sources = sources;
            this.filter = filter;
            this.outputSymbols = ImmutableList.copyOf(outputSymbols);
            this.pushedProjectionThroughJoin = pushedProjectionThroughJoin;
            List inputSymbols = (List)sources.stream().flatMap(source -> source.getOutputSymbols().stream()).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((boolean)inputSymbols.containsAll(outputSymbols), (Object)"inputs do not contain all output symbols");
        }

        public Expression getFilter() {
            return this.filter;
        }

        public LinkedHashSet<PlanNode> getSources() {
            return this.sources;
        }

        public List<Symbol> getOutputSymbols() {
            return this.outputSymbols;
        }

        public boolean isPushedProjectionThroughJoin() {
            return this.pushedProjectionThroughJoin;
        }

        public static Builder builder() {
            return new Builder();
        }

        public int hashCode() {
            return Objects.hash(this.sources, ImmutableSet.copyOf(IrUtils.extractConjuncts(this.filter)), this.outputSymbols, this.pushedProjectionThroughJoin);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiJoinNode)) {
                return false;
            }
            MultiJoinNode other = (MultiJoinNode)obj;
            return this.sources.equals(other.sources) && ImmutableSet.copyOf(IrUtils.extractConjuncts(this.filter)).equals((Object)ImmutableSet.copyOf(IrUtils.extractConjuncts(other.filter))) && this.outputSymbols.equals(other.outputSymbols) && this.pushedProjectionThroughJoin == other.pushedProjectionThroughJoin;
        }

        static MultiJoinNode toMultiJoinNode(JoinNode joinNode, Rule.Context context, boolean pushProjectionsThroughJoin) {
            return MultiJoinNode.toMultiJoinNode(joinNode, context.getLookup(), context.getIdAllocator(), SystemSessionProperties.getMaxReorderedJoins(context.getSession()), pushProjectionsThroughJoin, context.getSession());
        }

        static MultiJoinNode toMultiJoinNode(JoinNode joinNode, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, int joinLimit, boolean pushProjectionsThroughJoin, Session session) {
            return new JoinNodeFlattener(joinNode, lookup, planNodeIdAllocator, joinLimit + 1, pushProjectionsThroughJoin).toMultiJoinNode();
        }

        static class Builder {
            private List<PlanNode> sources;
            private Expression filter;
            private List<Symbol> outputSymbols;

            Builder() {
            }

            public Builder setSources(PlanNode ... sources) {
                this.sources = ImmutableList.copyOf((Object[])sources);
                return this;
            }

            public Builder setFilter(Expression filter) {
                this.filter = filter;
                return this;
            }

            public Builder setOutputSymbols(Symbol ... outputSymbols) {
                this.outputSymbols = ImmutableList.copyOf((Object[])outputSymbols);
                return this;
            }

            public MultiJoinNode build() {
                return new MultiJoinNode(new LinkedHashSet<PlanNode>(this.sources), this.filter, this.outputSymbols, false);
            }
        }

        private static class JoinNodeFlattener {
            private final Lookup lookup;
            private final PlanNodeIdAllocator planNodeIdAllocator;
            private final LinkedHashSet<PlanNode> sources = new LinkedHashSet();
            private final List<Expression> filters = new ArrayList<Expression>();
            private final List<Symbol> outputSymbols;
            private final boolean pushProjectionsThroughJoin;
            private boolean pushedProjectionThroughJoin;

            JoinNodeFlattener(JoinNode node, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, int sourceLimit, boolean pushProjectionsThroughJoin) {
                Objects.requireNonNull(node, "node is null");
                Preconditions.checkState((node.getType() == JoinType.INNER ? 1 : 0) != 0, (Object)"join type must be INNER");
                this.outputSymbols = node.getOutputSymbols();
                this.lookup = Objects.requireNonNull(lookup, "lookup is null");
                this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
                this.pushProjectionsThroughJoin = pushProjectionsThroughJoin;
                this.flattenNode(node, sourceLimit);
            }

            private void flattenNode(PlanNode node, int limit) {
                JoinNode joinNode;
                block8: {
                    block7: {
                        PlanNode resolved = this.lookup.resolve(node);
                        if (resolved instanceof ProjectNode) {
                            if (!this.pushProjectionsThroughJoin) {
                                this.sources.add(node);
                                return;
                            }
                            Optional<PlanNode> rewrittenNode = PushProjectionThroughJoin.pushProjectionThroughJoin((ProjectNode)resolved, this.lookup, this.planNodeIdAllocator);
                            if (rewrittenNode.isEmpty()) {
                                this.sources.add(node);
                                return;
                            }
                            this.pushedProjectionThroughJoin = true;
                            this.flattenNode(rewrittenNode.get(), limit);
                            return;
                        }
                        if (!(resolved instanceof JoinNode)) break block7;
                        joinNode = (JoinNode)resolved;
                        if (this.sources.size() <= limit - 2) break block8;
                    }
                    this.sources.add(node);
                    return;
                }
                if (joinNode.getType() != JoinType.INNER || !DeterminismEvaluator.isDeterministic(joinNode.getFilter().orElse(Booleans.TRUE)) || joinNode.getDistributionType().isPresent()) {
                    this.sources.add(node);
                    return;
                }
                this.flattenNode(joinNode.getLeft(), limit - 1);
                this.flattenNode(joinNode.getRight(), limit);
                joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::toExpression).forEach(this.filters::add);
                joinNode.getFilter().ifPresent(this.filters::add);
            }

            MultiJoinNode toMultiJoinNode() {
                return new MultiJoinNode(this.sources, IrUtils.and(this.filters), this.outputSymbols, this.pushedProjectionThroughJoin);
            }
        }
    }

    @VisibleForTesting
    static class JoinEnumerationResult {
        static final JoinEnumerationResult UNKNOWN_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.unknown());
        static final JoinEnumerationResult INFINITE_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.infinite());
        private final Optional<PlanNode> planNode;
        private final PlanCostEstimate cost;

        private JoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            this.planNode = Objects.requireNonNull(planNode, "planNode is null");
            this.cost = Objects.requireNonNull(cost, "cost is null");
            Preconditions.checkArgument(((cost.hasUnknownComponents() || cost.equals(PlanCostEstimate.infinite())) && planNode.isEmpty() || (!cost.hasUnknownComponents() || !cost.equals(PlanCostEstimate.infinite())) && planNode.isPresent() ? 1 : 0) != 0, (Object)"planNode should be present if and only if cost is known");
        }

        public Optional<PlanNode> getPlanNode() {
            return this.planNode;
        }

        public PlanCostEstimate getCost() {
            return this.cost;
        }

        static JoinEnumerationResult createJoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            if (cost.hasUnknownComponents()) {
                return UNKNOWN_COST_RESULT;
            }
            if (cost.equals(PlanCostEstimate.infinite())) {
                return INFINITE_COST_RESULT;
            }
            return new JoinEnumerationResult(planNode, cost);
        }
    }

    @VisibleForTesting
    static class JoinEnumerator {
        private final Session session;
        private final StatsProvider statsProvider;
        private final CostProvider costProvider;
        private final Ordering<JoinEnumerationResult> resultComparator;
        private final PlanNodeIdAllocator idAllocator;
        private final EqualityInference allFilterInference;
        private final Lookup lookup;
        private final Rule.Context context;
        private final Map<Set<PlanNode>, JoinEnumerationResult> memo = new HashMap<Set<PlanNode>, JoinEnumerationResult>();
        private final List<Expression> residuals;

        @VisibleForTesting
        JoinEnumerator(CostComparator costComparator, Expression filter, Rule.Context context, PlannerContext plannerContext) {
            this.context = Objects.requireNonNull(context);
            this.session = Objects.requireNonNull(context.getSession(), "session is null");
            this.statsProvider = Objects.requireNonNull(context.getStatsProvider(), "statsProvider is null");
            this.costProvider = Objects.requireNonNull(context.getCostProvider(), "costProvider is null");
            this.resultComparator = costComparator.forSession(this.session).onResultOf(result -> result.cost);
            this.idAllocator = Objects.requireNonNull(context.getIdAllocator(), "idAllocator is null");
            this.lookup = Objects.requireNonNull(context.getLookup(), "lookup is null");
            ImmutableList.Builder residuals = ImmutableList.builder();
            ArrayList<Expression> inferenceCandidates = new ArrayList<Expression>();
            for (Expression conjunct : IrUtils.extractConjuncts(filter)) {
                if (EqualityInference.isInferenceCandidate(conjunct) && !IrExpressions.mayFail(plannerContext, conjunct)) {
                    inferenceCandidates.add(conjunct);
                    continue;
                }
                residuals.add((Object)conjunct);
            }
            this.residuals = residuals.build();
            this.allFilterInference = new EqualityInference(inferenceCandidates);
        }

        public JoinEnumerationResult choose(LinkedHashSet<PlanNode> sources, List<Symbol> outputSymbols) {
            JoinEnumerationResult result = this.chooseJoinOrder(sources, (Set<Symbol>)ImmutableSet.builder().addAll(outputSymbols).addAll(this.residuals.stream().flatMap(e -> SymbolsExtractor.extractAll(e).stream()).toList()).build());
            if (result.getPlanNode().isPresent()) {
                PlanNode plan = result.getPlanNode().get();
                if (!this.residuals.isEmpty()) {
                    plan = new FilterNode(this.idAllocator.getNextId(), result.getPlanNode().get(), IrUtils.combineConjuncts(this.residuals));
                }
                result = new JoinEnumerationResult(Optional.of(new ProjectNode(this.idAllocator.getNextId(), plan, Assignments.builder().putIdentities(outputSymbols).build())), result.getCost());
            }
            return result;
        }

        private JoinEnumerationResult chooseJoinOrder(LinkedHashSet<PlanNode> sources, Set<Symbol> requiredOutputs) {
            this.context.checkTimeoutNotExhausted();
            ImmutableSet multiJoinKey = ImmutableSet.copyOf(sources);
            JoinEnumerationResult bestResult = this.memo.get(multiJoinKey);
            if (bestResult == null) {
                Preconditions.checkState((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is less than or equal to one");
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                Set<Set<Integer>> partitions = JoinEnumerator.generatePartitions(sources.size());
                for (Set<Integer> partition : partitions) {
                    JoinEnumerationResult result = this.createJoinAccordingToPartitioning(sources, requiredOutputs, partition);
                    if (result.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                        this.memo.put((Set<PlanNode>)multiJoinKey, result);
                        return result;
                    }
                    if (result.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) continue;
                    resultBuilder.add((Object)result);
                }
                ImmutableList results = resultBuilder.build();
                if (results.isEmpty()) {
                    this.memo.put((Set<PlanNode>)multiJoinKey, JoinEnumerationResult.INFINITE_COST_RESULT);
                    return JoinEnumerationResult.INFINITE_COST_RESULT;
                }
                bestResult = (JoinEnumerationResult)this.resultComparator.min((Iterable)results);
                this.memo.put((Set<PlanNode>)multiJoinKey, bestResult);
            }
            bestResult.planNode.ifPresent(planNode -> log.debug("Least cost join was: %s", new Object[]{planNode}));
            return bestResult;
        }

        @VisibleForTesting
        static Set<Set<Integer>> generatePartitions(int totalNodes) {
            Preconditions.checkArgument((totalNodes > 1 ? 1 : 0) != 0, (Object)"totalNodes must be greater than 1");
            Set numbers = (Set)IntStream.range(0, totalNodes).boxed().collect(ImmutableSet.toImmutableSet());
            return (Set)Sets.powerSet((Set)numbers).stream().filter(subSet -> subSet.contains(0)).filter(subSet -> subSet.size() < numbers.size()).collect(ImmutableSet.toImmutableSet());
        }

        @VisibleForTesting
        JoinEnumerationResult createJoinAccordingToPartitioning(LinkedHashSet<PlanNode> sources, Set<Symbol> requiredOutputs, Set<Integer> partitioning) {
            ImmutableList sourceList = ImmutableList.copyOf(sources);
            LinkedHashSet leftSources = partitioning.stream().map(((List)sourceList)::get).collect(Collectors.toCollection(LinkedHashSet::new));
            LinkedHashSet rightSources = sources.stream().filter(source -> !leftSources.contains(source)).collect(Collectors.toCollection(LinkedHashSet::new));
            return this.createJoin(leftSources, rightSources, requiredOutputs);
        }

        private JoinEnumerationResult createJoin(LinkedHashSet<PlanNode> leftSources, LinkedHashSet<PlanNode> rightSources, Set<Symbol> requiredOutputs) {
            Set rightSymbols;
            Set leftSymbols = (Set)leftSources.stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet());
            List<Expression> joinPredicates = this.getJoinPredicates(leftSymbols, rightSymbols = (Set)rightSources.stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet()));
            List joinConditions = (List)joinPredicates.stream().filter(JoinEnumerator::isJoinEqualityCondition).map(predicate -> JoinEnumerator.toEquiJoinClause((Comparison)predicate, leftSymbols)).collect(ImmutableList.toImmutableList());
            if (joinConditions.isEmpty()) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            List joinFilters = (List)joinPredicates.stream().filter(predicate -> !JoinEnumerator.isJoinEqualityCondition(predicate)).collect(ImmutableList.toImmutableList());
            ImmutableSet requiredJoinSymbols = ImmutableSet.builder().addAll(requiredOutputs).addAll(SymbolsExtractor.extractUnique(joinPredicates)).build();
            JoinEnumerationResult leftResult = this.getJoinSource(leftSources, (Set)requiredJoinSymbols.stream().filter(leftSymbols::contains).collect(ImmutableSet.toImmutableSet()));
            if (leftResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (leftResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode left = leftResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            JoinEnumerationResult rightResult = this.getJoinSource(rightSources, (Set)requiredJoinSymbols.stream().filter(rightSymbols::contains).collect(ImmutableSet.toImmutableSet()));
            if (rightResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (rightResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode right = rightResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            List leftOutputSymbols = (List)left.getOutputSymbols().stream().filter(requiredOutputs::contains).collect(ImmutableList.toImmutableList());
            List rightOutputSymbols = (List)right.getOutputSymbols().stream().filter(requiredOutputs::contains).collect(ImmutableList.toImmutableList());
            return this.setJoinNodeProperties(new JoinNode(this.idAllocator.getNextId(), JoinType.INNER, left, right, joinConditions, leftOutputSymbols, rightOutputSymbols, false, joinFilters.isEmpty() ? Optional.empty() : Optional.of(IrUtils.and(joinFilters)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty()));
        }

        private List<Expression> getJoinPredicates(Set<Symbol> leftSymbols, Set<Symbol> rightSymbols) {
            ImmutableList.Builder joinPredicatesBuilder = ImmutableList.builder();
            List<Expression> joinEqualities = this.allFilterInference.generateEqualitiesPartitionedBy((Set<Symbol>)Sets.union(leftSymbols, rightSymbols)).getScopeEqualities();
            EqualityInference joinInference = new EqualityInference(joinEqualities);
            joinPredicatesBuilder.addAll(joinInference.generateEqualitiesPartitionedBy(leftSymbols).getScopeStraddlingEqualities());
            return joinPredicatesBuilder.build();
        }

        private JoinEnumerationResult getJoinSource(LinkedHashSet<PlanNode> nodes, Set<Symbol> requiredOutputs) {
            if (nodes.size() == 1) {
                PlanNode planNode = (PlanNode)Iterables.getOnlyElement(nodes);
                ImmutableSet scope = ImmutableSet.copyOf(requiredOutputs);
                Expression filter = IrUtils.combineConjuncts(this.allFilterInference.generateEqualitiesPartitionedBy((Set<Symbol>)scope).getScopeEqualities());
                if (!Booleans.TRUE.equals(filter)) {
                    planNode = new FilterNode(this.idAllocator.getNextId(), planNode, filter);
                }
                return this.createJoinEnumerationResult(planNode);
            }
            return this.chooseJoinOrder(nodes, requiredOutputs);
        }

        private static boolean isJoinEqualityCondition(Expression expression) {
            return expression instanceof Comparison && ((Comparison)expression).operator() == Comparison.Operator.EQUAL && ((Comparison)expression).left() instanceof Reference && ((Comparison)expression).right() instanceof Reference;
        }

        private static JoinNode.EquiJoinClause toEquiJoinClause(Comparison equality, Set<Symbol> leftSymbols) {
            Symbol leftSymbol = Symbol.from(equality.left());
            Symbol rightSymbol = Symbol.from(equality.right());
            JoinNode.EquiJoinClause equiJoinClause = new JoinNode.EquiJoinClause(leftSymbol, rightSymbol);
            return leftSymbols.contains(leftSymbol) ? equiJoinClause : equiJoinClause.flip();
        }

        private JoinEnumerationResult setJoinNodeProperties(JoinNode joinNode) {
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getLeft(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.flipChildren().withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            List<JoinEnumerationResult> possibleJoinNodes = this.getPossibleJoinNodes(joinNode, SystemSessionProperties.getJoinDistributionType(this.session));
            Verify.verify((!possibleJoinNodes.isEmpty() ? 1 : 0) != 0, (String)"possibleJoinNodes is empty", (Object[])new Object[0]);
            if (possibleJoinNodes.stream().anyMatch(JoinEnumerationResult.UNKNOWN_COST_RESULT::equals)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            return (JoinEnumerationResult)this.resultComparator.min(possibleJoinNodes);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, OptimizerConfig.JoinDistributionType distributionType) {
            Preconditions.checkArgument((joinNode.getType() == JoinType.INNER ? 1 : 0) != 0, (String)"unexpected join node type: %s", (Object)((Object)joinNode.getType()));
            if (joinNode.isCrossJoin()) {
                return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
            }
            return switch (distributionType) {
                default -> throw new MatchException(null, null);
                case OptimizerConfig.JoinDistributionType.PARTITIONED -> this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED);
                case OptimizerConfig.JoinDistributionType.BROADCAST -> this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
                case OptimizerConfig.JoinDistributionType.AUTOMATIC -> ImmutableList.builder().addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED)).addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED, node -> DetermineJoinDistributionType.canReplicate(node, this.context))).build();
            };
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType) {
            return this.getPossibleJoinNodes(joinNode, distributionType, node -> true);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType, Predicate<JoinNode> isAllowed) {
            ImmutableList nodes = ImmutableList.of((Object)joinNode.withDistributionType(distributionType), (Object)joinNode.flipChildren().withDistributionType(distributionType));
            return (List)nodes.stream().filter(isAllowed).map(this::createJoinEnumerationResult).collect(ImmutableList.toImmutableList());
        }

        private JoinEnumerationResult createJoinEnumerationResult(JoinNode joinNode) {
            PlanCostEstimate costEstimate = this.costProvider.getCost(joinNode);
            PlanNodeStatsEstimate statsEstimate = this.statsProvider.getStats(joinNode);
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(joinNode.withReorderJoinStatsAndCost(new PlanNodeStatsAndCostSummary(statsEstimate.getOutputRowCount(), statsEstimate.getOutputSizeInBytes(joinNode.getOutputSymbols()), costEstimate.getCpuCost(), costEstimate.getMaxMemory(), costEstimate.getNetworkCost()))), costEstimate);
        }

        private JoinEnumerationResult createJoinEnumerationResult(PlanNode planNode) {
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(planNode), this.costProvider.getCost(planNode));
        }
    }
}

