/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;

public class RemoveRedundantWindow
implements Rule<WindowNode> {
    private static final Pattern<WindowNode> PATTERN = Patterns.window();

    @Override
    public Pattern<WindowNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(WindowNode window, Captures captures, Rule.Context context) {
        if (QueryCardinalityUtil.isEmpty(window.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(window.getId(), window.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }
}

