/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.Cardinality;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;

public class RemoveRedundantSort
implements Rule<SortNode> {
    private static final Pattern<SortNode> PATTERN = Patterns.sort();

    @Override
    public Pattern<SortNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SortNode node, Captures captures, Rule.Context context) {
        Cardinality cardinality = QueryCardinalityUtil.extractCardinality(node.getSource(), context.getLookup());
        if (cardinality.isEmpty()) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        if (cardinality.isScalar()) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        return Rule.Result.empty();
    }
}

