/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushMergeWriterUpdateIntoConnector
implements Rule<TableFinishNode> {
    private static final Capture<MergeWriterNode> MERGE_WRITER_NODE_CAPTURE = Capture.newCapture();
    private static final Capture<MergeProcessorNode> MERGE_PROCESSOR_NODE_CAPTURE = Capture.newCapture();
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Capture<ProjectNode> PROJECT_NODE_CAPTURE = Capture.newCapture();
    private static final Pattern<TableFinishNode> PATTERN = Patterns.tableFinish().with(Patterns.source().matching(Patterns.mergeWriter().capturedAs(MERGE_WRITER_NODE_CAPTURE).with(Patterns.source().matching(Patterns.mergeProcessor().capturedAs(MERGE_PROCESSOR_NODE_CAPTURE).with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT_NODE_CAPTURE).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)))))))));
    private final Metadata metadata;

    public PushMergeWriterUpdateIntoConnector(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<TableFinishNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFinishNode node, Captures captures, Rule.Context context) {
        Expression mergeRow;
        MergeWriterNode mergeWriter = (MergeWriterNode)captures.get(MERGE_WRITER_NODE_CAPTURE);
        MergeProcessorNode mergeProcessor = (MergeProcessorNode)captures.get(MERGE_PROCESSOR_NODE_CAPTURE);
        ProjectNode project = (ProjectNode)captures.get(PROJECT_NODE_CAPTURE);
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(context.getSession(), mergeWriter.getTarget().getHandle());
        List<String> orderedColumnNames = mergeWriter.getTarget().getMergeParadigmAndTypes().getColumnNames();
        Map<ColumnHandle, io.trino.spi.expression.Constant> assignments = this.buildAssignments(orderedColumnNames, mergeRow = project.getAssignments().get(mergeProcessor.getMergeRowSymbol()), columnHandles, context);
        if (assignments.isEmpty()) {
            return Rule.Result.empty();
        }
        return this.metadata.applyUpdate(context.getSession(), tableScan.getTable(), assignments).map(newHandle -> new TableUpdateNode(context.getIdAllocator().getNextId(), (TableHandle)newHandle, (Symbol)Iterables.getOnlyElement(node.getOutputSymbols()))).map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }

    private Map<ColumnHandle, io.trino.spi.expression.Constant> buildAssignments(List<String> orderedColumnNames, Expression mergeRow, Map<String, ColumnHandle> columnHandles, Rule.Context context) {
        ImmutableMap.Builder assignments;
        block4: {
            block3: {
                assignments = ImmutableMap.builder();
                if (!(mergeRow instanceof Row)) break block3;
                Row row = (Row)mergeRow;
                List<? extends Expression> fields = row.children();
                for (int i = 0; i < orderedColumnNames.size(); ++i) {
                    String columnName = orderedColumnNames.get(i);
                    Expression field = fields.get(i);
                    if (field instanceof Reference) continue;
                    Optional<ConnectorExpression> connectorExpression = ConnectorExpressionTranslator.translate(context.getSession(), field);
                    if (connectorExpression.isEmpty() || !(connectorExpression.get() instanceof io.trino.spi.expression.Constant)) {
                        return ImmutableMap.of();
                    }
                    assignments.put((Object)columnHandles.get(columnName), (Object)((io.trino.spi.expression.Constant)connectorExpression.get()));
                }
                break block4;
            }
            if (!(mergeRow instanceof Constant)) break block4;
            Constant row = (Constant)mergeRow;
            RowType type = (RowType)row.type();
            SqlRow rowValue = (SqlRow)row.value();
            for (int i = 0; i < orderedColumnNames.size(); ++i) {
                Type fieldType = ((RowType.Field)type.getFields().get(i)).getType();
                Object fieldValue = TypeUtils.readNativeValue((Type)fieldType, (Block)rowValue.getRawFieldBlock(i), (int)rowValue.getRawIndex());
                assignments.put((Object)columnHandles.get(orderedColumnNames.get(i)), (Object)new io.trino.spi.expression.Constant(fieldValue, fieldType));
            }
        }
        return assignments.buildOrThrow();
    }
}

