/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import java.util.List;

public class GatherPartialTopN
implements Rule<ExchangeNode> {
    private static final Capture<TopNNode> TOPN = Capture.newCapture();
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange().matching(GatherPartialTopN::isGatherRemoteExchange).with(Patterns.source().matching(Patterns.topN().matching(topN -> topN.getStep().equals((Object)TopNNode.Step.PARTIAL)).with(Patterns.source().matching(source -> !GatherPartialTopN.isGatherLocalExchange(source))).capturedAs(TOPN)));

    private static boolean isGatherLocalExchange(PlanNode source) {
        ExchangeNode exchange;
        return source instanceof ExchangeNode && (exchange = (ExchangeNode)source).getScope().equals((Object)ExchangeNode.Scope.LOCAL) && exchange.getType().equals((Object)ExchangeNode.Type.GATHER);
    }

    private static boolean isGatherRemoteExchange(ExchangeNode exchangeNode) {
        return exchangeNode.getScope().equals((Object)ExchangeNode.Scope.REMOTE) && exchangeNode.getType().equals((Object)ExchangeNode.Type.GATHER) && exchangeNode.getOrderingScheme().isEmpty();
    }

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExchangeNode node, Captures captures, Rule.Context context) {
        TopNNode originalPartialTopN = (TopNNode)captures.get(TOPN);
        TopNNode roundRobinTopN = new TopNNode(context.getIdAllocator().getNextId(), ExchangeNode.partitionedExchange(context.getIdAllocator().getNextId(), ExchangeNode.Scope.LOCAL, originalPartialTopN, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), originalPartialTopN.getOutputSymbols())), originalPartialTopN.getCount(), originalPartialTopN.getOrderingScheme(), TopNNode.Step.PARTIAL);
        return Rule.Result.ofPlanNode(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new TopNNode(context.getIdAllocator().getNextId(), ExchangeNode.gatheringExchange(context.getIdAllocator().getNextId(), ExchangeNode.Scope.LOCAL, roundRobinTopN), originalPartialTopN.getCount(), originalPartialTopN.getOrderingScheme(), TopNNode.Step.PARTIAL))));
    }
}

