/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.SystemSessionProperties;
import io.trino.cost.TaskCountEstimator;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.Optional;

public class DetermineTableScanNodePartitioning
implements Rule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan().matching(tableScan -> tableScan.getUseConnectorNodePartitioning().isEmpty());
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final TaskCountEstimator taskCountEstimator;

    public DetermineTableScanNodePartitioning(Metadata metadata, NodePartitioningManager nodePartitioningManager, TaskCountEstimator taskCountEstimator) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableScanNode node, Captures captures, Rule.Context context) {
        int numberOfTasks;
        TableProperties properties = this.metadata.getTableProperties(context.getSession(), node.getTable());
        if (properties.getTablePartitioning().isEmpty()) {
            return Rule.Result.ofPlanNode(node.withUseConnectorNodePartitioning(false));
        }
        TableProperties.TablePartitioning partitioning = properties.getTablePartitioning().get();
        Optional<ConnectorBucketNodeMap> bucketNodeMap = this.nodePartitioningManager.getConnectorBucketNodeMap(context.getSession(), partitioning.partitioningHandle());
        if (bucketNodeMap.map(ConnectorBucketNodeMap::hasFixedMapping).orElse(false).booleanValue()) {
            return Rule.Result.ofPlanNode(node.withUseConnectorNodePartitioning(true));
        }
        if (!SystemSessionProperties.isUseTableScanNodePartitioning(context.getSession())) {
            return Rule.Result.ofPlanNode(node.withUseConnectorNodePartitioning(false));
        }
        int numberOfBuckets = bucketNodeMap.map(ConnectorBucketNodeMap::getBucketCount).orElseGet(() -> this.nodePartitioningManager.getNodeCount(context.getSession(), partitioning.partitioningHandle()));
        return Rule.Result.ofPlanNode(node.withUseConnectorNodePartitioning((double)numberOfBuckets / (double)(numberOfTasks = Math.max(this.taskCountEstimator.estimateSourceDistributedTaskCount(context.getSession()), 1)) >= SystemSessionProperties.getTableScanNodePartitioningMinBucketToTaskRatio(context.getSession())));
    }
}

