/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.Optional;

public class SimplifyRedundantCase
implements IrOptimizerRule {
    private final Metadata metadata;

    public SimplifyRedundantCase(PlannerContext context) {
        this.metadata = context.getMetadata();
    }

    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Case)) {
            return Optional.empty();
        }
        Case caseTerm = (Case)expression;
        if (caseTerm.whenClauses().size() != 1) {
            return Optional.empty();
        }
        WhenClause thenClause = caseTerm.whenClauses().getFirst();
        if (thenClause.getResult().equals(Booleans.TRUE) && caseTerm.defaultValue().equals(Booleans.FALSE)) {
            return Optional.of(thenClause.getOperand());
        }
        if (thenClause.getResult().equals(Booleans.FALSE) && caseTerm.defaultValue().equals(Booleans.TRUE)) {
            return Optional.of(IrExpressions.not(this.metadata, thenClause.getOperand()));
        }
        return Optional.empty();
    }
}

