/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class EvaluateLogical
implements IrOptimizerRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Logical.Operator operator;
        Object object;
        if (!(expression instanceof Logical)) return Optional.empty();
        Logical logical = (Logical)expression;
        try {
            object = logical.operator();
            operator = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object terms = object = logical.terms();
        Constant shortCircuit = switch (operator) {
            default -> throw new MatchException(null, null);
            case Logical.Operator.AND -> Booleans.FALSE;
            case Logical.Operator.OR -> Booleans.TRUE;
        };
        Constant ignore = switch (operator) {
            default -> throw new MatchException(null, null);
            case Logical.Operator.AND -> Booleans.TRUE;
            case Logical.Operator.OR -> Booleans.FALSE;
        };
        if (terms.stream().anyMatch((Predicate<Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/trino/sql/ir/Expression;)Z)((Expression)shortCircuit))) {
            return Optional.of(shortCircuit);
        }
        List<Expression> residuals = terms.stream().filter(term -> !term.equals(ignore)).toList();
        if (residuals.isEmpty()) {
            return Optional.of(ignore);
        }
        if (!residuals.stream().allMatch(IrExpressions::isConstantNull)) return Optional.empty();
        return Optional.of(Booleans.NULL_BOOLEAN);
    }
}

