/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.Symbol;
import io.trino.type.TypeCoercion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IrExpressionEvaluator {
    private static final MethodHandle LAMBDA_EVALUATOR;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final Metadata metadata;

    public IrExpressionEvaluator(PlannerContext context) {
        this.metadata = context.getMetadata();
        this.functionInvoker = new InterpretedFunctionInvoker(context.getFunctionManager());
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)context.getTypeManager()).getType(arg_0));
    }

    public Object evaluate(Expression expression, Session session, Map<String, Object> bindings) {
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Array.class, Between.class, Bind.class, Call.class, Case.class, Cast.class, Coalesce.class, Comparison.class, Constant.class, FieldReference.class, In.class, IsNull.class, Lambda.class, Logical.class, NullIf.class, Reference.class, Row.class, Switch.class}, (Object)expression3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Array e = (Array)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 1 -> {
                Between e = (Between)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 2 -> {
                Bind e = (Bind)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 3 -> {
                Call e = (Call)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 4 -> {
                Case e = (Case)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 5 -> {
                Cast e = (Cast)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 6 -> {
                Coalesce e = (Coalesce)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 7 -> {
                Comparison e = (Comparison)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 8 -> {
                Constant e = (Constant)expression3;
                yield e.value();
            }
            case 9 -> {
                FieldReference e = (FieldReference)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 10 -> {
                In e = (In)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 11 -> {
                IsNull e = (IsNull)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 12 -> {
                Lambda e = (Lambda)expression3;
                yield this.makeLambdaInvoker(session, e);
            }
            case 13 -> {
                Logical e = (Logical)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 14 -> {
                NullIf e = (NullIf)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 15 -> {
                Reference reference = (Reference)expression3;
                yield bindings.get(reference.name());
            }
            case 16 -> {
                Row e = (Row)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
            case 17 -> {
                Switch e = (Switch)expression3;
                yield this.evaluateInternal(e, session, bindings);
            }
        };
    }

    private Object evaluateInternal(Bind bind, Session session, Map<String, Object> assignments) {
        HashMap<String, Constant> bindings = new HashMap<String, Constant>();
        for (int i = 0; i < bind.values().size(); ++i) {
            Symbol argument = bind.function().arguments().get(i);
            Object value = this.evaluate(bind.values().get(i), session, assignments);
            bindings.put(argument.name(), new Constant(argument.type(), value));
        }
        return this.makeLambdaInvoker(session, new Lambda(bind.function().arguments().subList(bind.values().size(), bind.function().arguments().size()), this.substituteBindings(bind.function().body(), bindings)));
    }

    private Expression substituteBindings(Expression expression, final Map<String, Constant> bindings) {
        ExpressionTreeRewriter<Void> rewriter = new ExpressionTreeRewriter<Void>(new ExpressionRewriter<Void>(this){

            @Override
            public Expression rewriteReference(Reference reference, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Constant constant = (Constant)bindings.get(reference.name());
                return constant == null ? reference : constant;
            }
        });
        return rewriter.rewrite(expression, null);
    }

    private Object evaluateInternal(Switch expression, Session session, Map<String, Object> bindings) {
        Expression operand = expression.operand();
        Object value = this.evaluate(operand, session, bindings);
        if (value == null) {
            return this.evaluate(expression.defaultValue(), session, bindings);
        }
        ConnectorSession connectorSession = session.toConnectorSession();
        ResolvedFunction equals = this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)operand.type(), (Object)operand.type()));
        for (WhenClause clause : expression.whenClauses()) {
            Object candidate = this.evaluate(clause.getOperand(), session, bindings);
            if (!Boolean.TRUE.equals(this.functionInvoker.invoke(equals, connectorSession, Arrays.asList(value, candidate)))) continue;
            return this.evaluate(clause.getResult(), session, bindings);
        }
        return this.evaluate(expression.defaultValue(), session, bindings);
    }

    private Object evaluateInternal(Row expression, Session session, Map<String, Object> bindings) {
        return RowValueBuilder.buildRowValue((RowType)((RowType)expression.type()), builders -> {
            for (int i = 0; i < expression.items().size(); ++i) {
                TypeUtils.writeNativeValue((Type)expression.items().get(i).type(), (BlockBuilder)((BlockBuilder)builders.get(i)), (Object)this.evaluate(expression.items().get(i), session, bindings));
            }
        });
    }

    private Object evaluateInternal(NullIf expression, Session session, Map<String, Object> bindings) {
        ConnectorSession connectorSession = session.toConnectorSession();
        Object first = this.evaluate(expression.first(), session, bindings);
        Object second = this.evaluate(expression.second(), session, bindings);
        Type commonType = this.typeCoercion.getCommonSuperType(expression.first().type(), expression.second().type()).orElseThrow();
        boolean equal = Boolean.TRUE.equals(this.functionInvoker.invoke(this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType)), connectorSession, (List<Object>)ImmutableList.of((Object)this.functionInvoker.invoke(this.metadata.getCoercion(expression.first().type(), commonType), connectorSession, (List<Object>)ImmutableList.of((Object)first)), (Object)this.functionInvoker.invoke(this.metadata.getCoercion(expression.second().type(), commonType), connectorSession, (List<Object>)ImmutableList.of((Object)second)))));
        return equal ? null : first;
    }

    private Object evaluateInternal(Logical expression, Session session, Map<String, Object> bindings) {
        Boolean shortCircuit = switch (expression.operator()) {
            default -> throw new MatchException(null, null);
            case Logical.Operator.AND -> Boolean.FALSE;
            case Logical.Operator.OR -> Boolean.TRUE;
        };
        boolean hasNull = false;
        for (Expression term : expression.terms()) {
            Object value = this.evaluate(term, session, bindings);
            if (shortCircuit.equals(value)) {
                return shortCircuit;
            }
            if (value != null) continue;
            hasNull = true;
        }
        if (hasNull) {
            return null;
        }
        return shortCircuit == false;
    }

    private Object evaluateInternal(IsNull expression, Session session, Map<String, Object> bindings) {
        return this.evaluate(expression.value(), session, bindings) == null;
    }

    private Object evaluateInternal(In expression, Session session, Map<String, Object> bindings) {
        Object value = this.evaluate(expression.value(), session, bindings);
        if (value == null) {
            return null;
        }
        ConnectorSession connectorSession = session.toConnectorSession();
        ResolvedFunction equals = this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)expression.value().type(), (Object)expression.value().type()));
        boolean hasNull = false;
        List<Object> candidates = expression.valueList().stream().map(item -> this.evaluate((Expression)item, session, bindings)).toList();
        for (Object candidate : candidates) {
            Object result = this.functionInvoker.invoke(equals, connectorSession, Arrays.asList(value, candidate));
            if (Boolean.TRUE.equals(result)) {
                return true;
            }
            if (result != null) continue;
            hasNull = true;
        }
        return hasNull ? null : Boolean.valueOf(false);
    }

    private Object evaluateInternal(FieldReference expression, Session session, Map<String, Object> bindings) {
        SqlRow row = (SqlRow)this.evaluate(expression.base(), session, bindings);
        return TypeUtils.readNativeValue((Type)expression.type(), (Block)row.getRawFieldBlock(expression.field()), (int)row.getRawIndex());
    }

    private Object evaluateInternal(Comparison expression, Session session, Map<String, Object> bindings) {
        Object left = this.evaluate(expression.left(), session, bindings);
        Type leftType = expression.left().type();
        Object right = this.evaluate(expression.right(), session, bindings);
        Type rightType = expression.right().type();
        return switch (expression.operator()) {
            default -> throw new MatchException(null, null);
            case Comparison.Operator.EQUAL -> this.evaluateOperator(OperatorType.EQUAL, leftType, rightType, left, right, session);
            case Comparison.Operator.NOT_EQUAL -> {
                Object result = this.evaluateOperator(OperatorType.EQUAL, leftType, rightType, left, right, session);
                if (result == null) {
                    yield null;
                }
                yield (Boolean)result == false;
            }
            case Comparison.Operator.LESS_THAN -> this.evaluateOperator(OperatorType.LESS_THAN, leftType, rightType, left, right, session);
            case Comparison.Operator.LESS_THAN_OR_EQUAL -> this.evaluateOperator(OperatorType.LESS_THAN_OR_EQUAL, leftType, rightType, left, right, session);
            case Comparison.Operator.GREATER_THAN -> this.evaluateOperator(OperatorType.LESS_THAN, rightType, leftType, right, left, session);
            case Comparison.Operator.GREATER_THAN_OR_EQUAL -> this.evaluateOperator(OperatorType.LESS_THAN_OR_EQUAL, rightType, leftType, right, left, session);
            case Comparison.Operator.IDENTICAL -> this.evaluateOperator(OperatorType.IDENTICAL, leftType, rightType, left, right, session);
        };
    }

    private Object evaluateOperator(OperatorType operator, Type leftType, Type rightType, Object left, Object right, Session session) {
        return this.functionInvoker.invoke(this.metadata.resolveOperator(operator, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType)), session.toConnectorSession(), Arrays.asList(left, right));
    }

    private Object evaluateInternal(Coalesce expression, Session session, Map<String, Object> bindings) {
        for (Expression operand : expression.operands()) {
            Object value = this.evaluate(operand, session, bindings);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Object evaluateInternal(Cast cast, Session session, Map<String, Object> bindings) {
        return this.functionInvoker.invoke(this.metadata.getCoercion(cast.expression().type(), cast.type()), session.toConnectorSession(), Collections.singletonList(this.evaluate(cast.expression(), session, bindings)));
    }

    private Object evaluateInternal(Case expression, Session session, Map<String, Object> bindings) {
        for (WhenClause whenClause : expression.whenClauses()) {
            Object operand = this.evaluate(whenClause.getOperand(), session, bindings);
            if (!Boolean.TRUE.equals(operand)) continue;
            return this.evaluate(whenClause.getResult(), session, bindings);
        }
        return this.evaluate(expression.defaultValue(), session, bindings);
    }

    private Object evaluateInternal(Call call, Session session, Map<String, Object> bindings) {
        return this.functionInvoker.invoke(call.function(), session.toConnectorSession(), call.arguments().stream().map(argument -> this.evaluate((Expression)argument, session, bindings)).collect(Collectors.toList()));
    }

    private MethodHandle makeLambdaInvoker(Session session, Lambda lambda) {
        HashMap<String, Integer> mappings = new HashMap<String, Integer>();
        for (int i = 0; i < lambda.arguments().size(); ++i) {
            mappings.put(lambda.arguments().get(i).name(), i);
        }
        return LAMBDA_EVALUATOR.bindTo(this).bindTo(session).bindTo(lambda.body()).bindTo(mappings).asVarargsCollector(Object[].class);
    }

    private Object evaluate(Session session, Expression body, Map<String, Integer> mappings, Object ... arguments) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : mappings.entrySet()) {
            bindings.put(entry.getKey(), arguments[entry.getValue()]);
        }
        return this.evaluate(body, session, bindings);
    }

    private Object evaluateInternal(Between expression, Session session, Map<String, Object> bindings) {
        Object value = this.evaluate(expression.value(), session, bindings);
        Object min = this.evaluate(expression.min(), session, bindings);
        Object max = this.evaluate(expression.max(), session, bindings);
        Object low = this.evaluateOperator(OperatorType.LESS_THAN_OR_EQUAL, expression.min().type(), expression.value().type(), min, value, session);
        Object high = this.evaluateOperator(OperatorType.LESS_THAN_OR_EQUAL, expression.value().type(), expression.max().type(), value, max, session);
        if (Boolean.FALSE.equals(low) || Boolean.FALSE.equals(high)) {
            return Boolean.FALSE;
        }
        if (Boolean.TRUE.equals(low) && Boolean.TRUE.equals(high)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private Object evaluateInternal(Array expression, Session session, Map<String, Object> bindings) {
        List<Object> values = expression.elements().stream().map(e -> this.evaluate((Expression)e, session, bindings)).toList();
        BlockBuilder builder = expression.elementType().createBlockBuilder(null, values.size());
        for (Object element : values) {
            TypeUtils.writeNativeValue((Type)expression.elementType(), (BlockBuilder)builder, (Object)element);
        }
        return builder.build();
    }

    static {
        try {
            LAMBDA_EVALUATOR = MethodHandles.lookup().findVirtual(IrExpressionEvaluator.class, "evaluate", MethodType.methodType(Object.class, Session.class, Expression.class, Map.class, Object[].class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

