/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record Reference(Type type, String name) implements Expression
{
    public Reference {
        Objects.requireNonNull(name, "name is null");
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitReference(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return this.name + "::" + String.valueOf(this.type);
    }
}

