/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record Call(ResolvedFunction function, List<Expression> arguments) implements Expression
{
    public Call {
        arguments = ImmutableList.copyOf(arguments);
        Preconditions.checkArgument((function.signature().getArgumentTypes().size() == arguments.size() ? 1 : 0) != 0, (String)"Expected %s arguments, found: %s", (int)function.signature().getArgumentTypes().size(), (int)arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            IrUtils.validateType(function.signature().getArgumentType(i), (Expression)arguments.get(i));
        }
    }

    @Override
    public Type type() {
        return this.function.signature().getReturnType();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCall(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return "%s(%s)".formatted(GlobalFunctionCatalog.isBuiltinFunctionName(this.function.name()) ? this.function.name().getFunctionName() : this.function.name(), this.arguments.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
    }
}

