/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.log.Logger;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.metadata.FunctionManager;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageFieldsToInputParametersRewriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.columnar.BetweenInlineColumnarFilterGenerator;
import io.trino.sql.gen.columnar.CallColumnarFilterGenerator;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.gen.columnar.InColumnarFilterGenerator;
import io.trino.sql.gen.columnar.IsNotNullColumnarFilter;
import io.trino.sql.gen.columnar.IsNullColumnarFilter;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.util.CompilerUtils;
import jakarta.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.objectweb.asm.MethodTooLargeException;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ColumnarFilterCompiler {
    private static final Logger log = Logger.get(ColumnarFilterCompiler.class);
    private final FunctionManager functionManager;
    private final NonEvictableLoadingCache<RowExpression, Optional<Supplier<ColumnarFilter>>> filterCache;
    private final CacheStatsMBean filterCacheStats;

    @Inject
    public ColumnarFilterCompiler(FunctionManager functionManager, CompilerConfig config) {
        this(functionManager, config.getExpressionCacheSize());
    }

    public ColumnarFilterCompiler(FunctionManager functionManager, int expressionCacheSize) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        if (expressionCacheSize > 0) {
            this.filterCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize), (CacheLoader)CacheLoader.from(this::generateFilterInternal));
            this.filterCacheStats = new CacheStatsMBean(this.filterCache);
        } else {
            this.filterCache = null;
            this.filterCacheStats = null;
        }
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getFilterCache() {
        return this.filterCacheStats;
    }

    public Optional<Supplier<ColumnarFilter>> generateFilter(RowExpression filter) {
        if (this.filterCache == null) {
            return this.generateFilterInternal(filter);
        }
        return (Optional)this.filterCache.getUnchecked((Object)filter);
    }

    private Optional<Supplier<ColumnarFilter>> generateFilterInternal(RowExpression filter) {
        try {
            if (filter instanceof CallExpression) {
                CallExpression callExpression = (CallExpression)filter;
                if (FilterEvaluator.isNotExpression(callExpression)) {
                    SpecialForm specialForm;
                    RowExpression rowExpression = callExpression.arguments().getFirst();
                    if (rowExpression instanceof SpecialForm && (specialForm = (SpecialForm)rowExpression).form() == SpecialForm.Form.IS_NULL) {
                        return Optional.of(IsNotNullColumnarFilter.createIsNotNullColumnarFilter(specialForm));
                    }
                    return Optional.empty();
                }
                return Optional.of(new CallColumnarFilterGenerator(callExpression, this.functionManager).generateColumnarFilter());
            }
            if (filter instanceof SpecialForm) {
                SpecialForm specialForm = (SpecialForm)filter;
                if (specialForm.form() == SpecialForm.Form.IS_NULL) {
                    return Optional.of(IsNullColumnarFilter.createIsNullColumnarFilter(specialForm));
                }
                if (specialForm.form() == SpecialForm.Form.IN) {
                    return Optional.of(new InColumnarFilterGenerator(specialForm, this.functionManager).generateColumnarFilter());
                }
                if (specialForm.form() == SpecialForm.Form.BETWEEN) {
                    return Optional.of(new BetweenInlineColumnarFilterGenerator(specialForm, this.functionManager).generateColumnarFilter());
                }
            }
            return Optional.empty();
        }
        catch (Throwable t) {
            if (t instanceof UnsupportedOperationException || t.getCause() instanceof UnsupportedOperationException) {
                log.debug("Unsupported filter for columnar evaluation %s, %s", new Object[]{filter, t});
            } else {
                log.warn("Failed to compile filter %s for columnar evaluation, %s", new Object[]{filter, t});
            }
            return Optional.empty();
        }
    }

    static void generateGetInputChannels(CallSiteBinder callSiteBinder, ClassDefinition classDefinition, RowExpression rowExpression) {
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(rowExpression);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(InputChannels.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(result.getInputChannels(), InputChannels.class), "getInputChannels", new BytecodeExpression[0])).retObject();
    }

    static Supplier<ColumnarFilter> createClassInstance(CallSiteBinder binder, ClassDefinition classDefinition) {
        Constructor<ColumnarFilter> filterConstructor;
        try {
            Class<ColumnarFilter> functionClass = CompilerUtils.defineClass(classDefinition, ColumnarFilter.class, binder.getBindings(), ColumnarFilterCompiler.class.getClassLoader());
            filterConstructor = functionClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            if (Throwables.getRootCause((Throwable)e) instanceof MethodTooLargeException) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Query exceeded maximum filters. Please reduce the number of filters referenced and re-run the query.", (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, e.getCause());
        }
        return () -> {
            try {
                return (ColumnarFilter)filterConstructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    static void declareBlockVariables(List<RowExpression> rowExpressions, Parameter page, Scope scope, BytecodeBlock body) {
        int channel = 0;
        HashSet<Integer> inputFields = new HashSet<Integer>();
        for (RowExpression rowExpression : rowExpressions) {
            InputReferenceExpression inputReference;
            if (!(rowExpression instanceof InputReferenceExpression) || inputFields.contains((inputReference = (InputReferenceExpression)rowExpression).field())) continue;
            scope.declareVariable("block_" + inputReference.field(), body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
            inputFields.add(inputReference.field());
            ++channel;
        }
    }

    static BytecodeExpression generateBlockMayHaveNull(List<RowExpression> rowExpressions, Scope scope) {
        return ColumnarFilterCompiler.generateBlockMayHaveNull(rowExpressions, Collections.nCopies(rowExpressions.size(), false), scope);
    }

    static BytecodeExpression generateBlockMayHaveNull(List<RowExpression> rowExpressions, List<Boolean> isNullableArgument, Scope scope) {
        Preconditions.checkArgument((rowExpressions.size() == isNullableArgument.size() ? 1 : 0) != 0, (String)"rowExpressions size %s does not match isNullableArgument size %s", (int)rowExpressions.size(), (int)isNullableArgument.size());
        BytecodeExpression mayHaveNull = BytecodeExpressions.constantFalse();
        for (int i = 0; i < rowExpressions.size(); ++i) {
            RowExpression rowExpression = rowExpressions.get(i);
            if (!(rowExpression instanceof InputReferenceExpression)) continue;
            InputReferenceExpression inputReference = (InputReferenceExpression)rowExpression;
            if (isNullableArgument.get(i).booleanValue()) continue;
            mayHaveNull = BytecodeExpressions.or((BytecodeExpression)mayHaveNull, (BytecodeExpression)scope.getVariable("block_" + inputReference.field()).invoke("mayHaveNull", Boolean.TYPE, new BytecodeExpression[0]));
        }
        return mayHaveNull;
    }

    static BytecodeExpression generateBlockPositionNotNull(List<RowExpression> rowExpressions, Scope scope, Variable position) {
        return ColumnarFilterCompiler.generateBlockPositionNotNull(rowExpressions, Collections.nCopies(rowExpressions.size(), false), scope, position);
    }

    static BytecodeExpression generateBlockPositionNotNull(List<RowExpression> rowExpressions, List<Boolean> isNullableArgument, Scope scope, Variable position) {
        Preconditions.checkArgument((rowExpressions.size() == isNullableArgument.size() ? 1 : 0) != 0, (String)"rowExpressions size %s does not match isNullableArgument size %s", (int)rowExpressions.size(), (int)isNullableArgument.size());
        BytecodeExpression isNotNull = BytecodeExpressions.constantTrue();
        for (int i = 0; i < rowExpressions.size(); ++i) {
            RowExpression rowExpression = rowExpressions.get(i);
            if (!(rowExpression instanceof InputReferenceExpression)) continue;
            InputReferenceExpression inputReference = (InputReferenceExpression)rowExpression;
            if (isNullableArgument.get(i).booleanValue()) continue;
            isNotNull = BytecodeExpressions.and((BytecodeExpression)isNotNull, (BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)scope.getVariable("block_" + inputReference.field()).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})));
        }
        return isNotNull;
    }

    static BytecodeBlock updateOutputPositions(Variable result, Variable position, Parameter outputPositions, Variable outputPositionsCount) {
        return new BytecodeBlock().append((BytecodeNode)outputPositions.setElement((BytecodeExpression)outputPositionsCount, (BytecodeExpression)position)).append((BytecodeNode)outputPositionsCount.set(BytecodeExpressions.add((BytecodeExpression)outputPositionsCount, (BytecodeExpression)BytecodeExpressions.inlineIf((BytecodeExpression)result, (BytecodeExpression)BytecodeExpressions.constantInt((int)1), (BytecodeExpression)BytecodeExpressions.constantInt((int)0)))));
    }
}

