/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.errorprone.annotations.Immutable;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.Scope;
import java.util.Objects;

@Immutable
public class ResolvedField {
    private final Scope scope;
    private final Field field;
    private final int hierarchyFieldIndex;
    private final int relationFieldIndex;
    private final boolean local;

    public ResolvedField(Scope scope, Field field, int hierarchyFieldIndex, int relationFieldIndex, boolean local) {
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.hierarchyFieldIndex = hierarchyFieldIndex;
        this.relationFieldIndex = relationFieldIndex;
        this.local = local;
    }

    public FieldId getFieldId() {
        return FieldId.from(this);
    }

    public Type getType() {
        return this.field.getType();
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getHierarchyFieldIndex() {
        return this.hierarchyFieldIndex;
    }

    public int getRelationFieldIndex() {
        return this.relationFieldIndex;
    }

    public Field getField() {
        return this.field;
    }
}

