/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorPageSourceProviderFactory;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.split.PageSourceProvider;
import io.trino.split.PageSourceProviderFactory;
import java.util.List;
import java.util.Objects;

public class PageSourceManager
implements PageSourceProviderFactory {
    private final CatalogServiceProvider<ConnectorPageSourceProviderFactory> pageSourceProviderFactory;

    @Inject
    public PageSourceManager(CatalogServiceProvider<ConnectorPageSourceProviderFactory> pageSourceProviderFactory) {
        this.pageSourceProviderFactory = Objects.requireNonNull(pageSourceProviderFactory, "pageSourceProviderFactory is null");
    }

    @Override
    public PageSourceProvider createPageSourceProvider(CatalogHandle catalogHandle) {
        ConnectorPageSourceProviderFactory provider = this.pageSourceProviderFactory.getService(catalogHandle);
        return new PageSourceProviderInstance(provider.createPageSourceProvider());
    }

    private record PageSourceProviderInstance(ConnectorPageSourceProvider pageSourceProvider) implements PageSourceProvider
    {
        private PageSourceProviderInstance {
            Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        }

        @Override
        public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((boolean)split.getCatalogHandle().equals((Object)table.catalogHandle()), (Object)"mismatched split and table");
            TupleDomain constraint = dynamicFilter.getCurrentPredicate();
            if (constraint.isNone()) {
                return new EmptyPageSource();
            }
            if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
                dynamicFilter = DynamicFilter.EMPTY;
            }
            return this.pageSourceProvider.createPageSource(table.transaction(), session.toConnectorSession(table.catalogHandle()), split.getConnectorSplit(), table.connectorHandle(), columns, dynamicFilter);
        }
    }
}

