/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.ui.OAuthIdTokenCookie;
import io.trino.server.ui.OAuthWebUiCookie;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

@Path(value="/ui/logout")
public class OAuth2WebUiLogoutResource {
    private final OAuth2Client auth2Client;

    @Inject
    public OAuth2WebUiLogoutResource(OAuth2Client auth2Client) {
        this.auth2Client = Objects.requireNonNull(auth2Client, "auth2Client is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    public Response logout(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context SecurityContext securityContext) throws IOException {
        Optional<String> idToken = OAuthIdTokenCookie.read(httpHeaders.getCookies());
        URI callBackUri = UriBuilder.fromUri((URI)uriInfo.getAbsolutePath()).path("logout.html").build(new Object[0]);
        return Response.seeOther((URI)this.auth2Client.getLogoutEndpoint(idToken, callBackUri).orElse(callBackUri)).cookie(OAuthIdTokenCookie.delete(httpHeaders.getCookies())).cookie(OAuthWebUiCookie.delete(httpHeaders.getCookies())).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/logout.html")
    public Response logoutPage(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context SecurityContext securityContext) throws IOException {
        return Response.ok((Object)Resources.toString((URL)Resources.getResource(this.getClass(), (String)"/oauth2/logout.html"), (Charset)StandardCharsets.UTF_8)).build();
    }
}

