/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SecurityException;
import io.trino.server.security.jwt.JwkService;
import java.lang.runtime.SwitchBootstraps;
import java.security.Key;
import java.util.Objects;

public class JwkSigningKeyLocator
implements Locator<Key> {
    private final JwkService keys;

    public JwkSigningKeyLocator(JwkService keys) {
        this.keys = Objects.requireNonNull(keys, "keys is null");
    }

    public Key locate(Header header) {
        Header header2 = header;
        Objects.requireNonNull(header2);
        Header header3 = header2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JwsHeader.class, JweHeader.class}, (Object)header3, n)) {
            case 0 -> {
                JwsHeader jwsHeader = (JwsHeader)header3;
                yield this.getKey(jwsHeader.getKeyId());
            }
            case 1 -> {
                JweHeader jweHeader = (JweHeader)header3;
                yield this.getKey(jweHeader.getKeyId());
            }
            default -> throw new UnsupportedJwtException("Cannot locate key for header: %s".formatted(header.getType()));
        };
    }

    private Key getKey(String keyId) {
        if (keyId == null) {
            throw new SecurityException("Key ID is required");
        }
        return this.keys.getKey(keyId).orElseThrow(() -> new SecurityException("Unknown signing key ID"));
    }
}

