/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.server.security.AnnotatedResourceAccessTypeLoader;
import io.trino.server.security.ResourceAccessTypeLoader;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.ResourceSecurityBinder;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

public class ResourceAccessType {
    private final List<ResourceAccessTypeLoader> resourceAccessTypeLoaders;

    @Inject
    public ResourceAccessType(ResourceSecurityBinder.StaticResourceAccessTypeLoader staticResourceAccessTypeLoader) {
        this.resourceAccessTypeLoaders = ImmutableList.builder().add((Object)staticResourceAccessTypeLoader).add((Object)new AnnotatedResourceAccessTypeLoader()).build();
    }

    public ResourceSecurity.AccessType getAccessType(ResourceInfo resourceInfo) {
        for (ResourceAccessTypeLoader resourceAccessTypeLoader : this.resourceAccessTypeLoaders) {
            Optional<ResourceSecurity.AccessType> accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceMethod());
            if (accessType.isPresent()) {
                return accessType.get();
            }
            accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceClass());
            if (accessType.isPresent()) {
                ResourceAccessType.verifyNotTrinoResource(resourceInfo);
                return accessType.get();
            }
            if (resourceInfo.getResourceClass().getDeclaringClass() == null || !(accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceClass().getDeclaringClass())).isPresent()) continue;
            ResourceAccessType.verifyNotTrinoResource(resourceInfo);
            return accessType.get();
        }
        ResourceAccessType.verifyNotTrinoResource(resourceInfo);
        return ResourceSecurity.AccessType.MANAGEMENT_READ;
    }

    private static void verifyNotTrinoResource(ResourceInfo resourceInfo) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null && resourceMethod.getDeclaringClass().getPackageName().startsWith("io.trino.")) {
            throw new IllegalArgumentException("Trino resource is not annotated with @" + ResourceSecurity.class.getSimpleName() + ": " + String.valueOf(resourceInfo.getResourceMethod()));
        }
    }
}

