/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.PasswordAuthenticatorFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class PasswordAuthenticatorManager {
    private static final Logger log = Logger.get(PasswordAuthenticatorManager.class);
    private static final String NAME_PROPERTY = "password-authenticator.name";
    private final List<File> configFiles;
    private final AtomicBoolean required = new AtomicBoolean();
    private final Map<String, PasswordAuthenticatorFactory> factories = new ConcurrentHashMap<String, PasswordAuthenticatorFactory>();
    private final AtomicReference<List<PasswordAuthenticator>> authenticators = new AtomicReference();

    @Inject
    public PasswordAuthenticatorManager(PasswordAuthenticatorConfig config) {
        this.configFiles = ImmutableList.copyOf(config.getPasswordAuthenticatorFiles());
        Preconditions.checkArgument((!this.configFiles.isEmpty() ? 1 : 0) != 0, (Object)"password authenticator files list is empty");
    }

    public void setRequired() {
        this.required.set(true);
    }

    public void addPasswordAuthenticatorFactory(PasswordAuthenticatorFactory factory) {
        Preconditions.checkArgument((this.factories.putIfAbsent(factory.getName(), factory) == null ? 1 : 0) != 0, (String)"Password authenticator '%s' is already registered", (Object)factory.getName());
    }

    public boolean isLoaded() {
        return this.authenticators.get() != null;
    }

    public void loadPasswordAuthenticator() {
        if (!this.required.get()) {
            return;
        }
        ImmutableList.Builder authenticators = ImmutableList.builder();
        for (File configFile : this.configFiles) {
            authenticators.add((Object)this.loadAuthenticator(configFile.getAbsoluteFile()));
        }
        this.authenticators.set((List<PasswordAuthenticator>)authenticators.build());
    }

    private PasswordAuthenticator loadAuthenticator(File configFile) {
        PasswordAuthenticator authenticator;
        HashMap properties;
        try {
            properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Password authenticator configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        log.info("-- Loading password authenticator --");
        PasswordAuthenticatorFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Password authenticator '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            authenticator = factory.create((Map)ImmutableMap.copyOf(properties));
        }
        log.info("-- Loaded password authenticator %s --", new Object[]{name});
        return authenticator;
    }

    public List<PasswordAuthenticator> getAuthenticators() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"authenticators were not loaded");
        return this.authenticators.get();
    }

    @VisibleForTesting
    public void setAuthenticators(PasswordAuthenticator ... authenticators) {
        if (!this.authenticators.compareAndSet(null, (List<PasswordAuthenticator>)ImmutableList.copyOf((Object[])authenticators))) {
            throw new IllegalStateException("authenticators already loaded");
        }
    }
}

