/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.time.TimeOperators;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;
import java.util.Locale;

@Description(value="Add the specified amount of time to the given time")
@ScalarFunction(value="date_add")
public class DateAdd {
    private DateAdd() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time(p) with time zone") long packedTime) {
        long picos = DateAdd.add(DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L, unit, value);
        if (precision <= 3L) {
            picos = DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
        }
        return DateTimeEncoding.packTimeWithTimeZone((long)(picos / 1000L), (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone add(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        long picos = DateAdd.add(time.getPicoseconds(), unit, value);
        return new LongTimeWithTimeZone(picos, time.getOffsetMinutes());
    }

    private static long add(long picos, Slice unit, long value) {
        String unitString;
        long delta = switch (unitString = unit.toStringAscii().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> value % 86400000L * 1000000000L;
            case "second" -> value % 86400L * 1000000000000L;
            case "minute" -> value % 1440L * 60000000000000L;
            case "hour" -> value % 24L * 3600000000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
        return TimeOperators.add(picos, delta);
    }
}

