/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import io.trino.util.JsonUtil;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToJsonCast {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();

    private TimestampToJsonCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="json")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        return TimestampToJsonCast.toJson(DateTimes.formatTimestamp((int)precision, timestamp, 0, ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="json")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToJsonCast.toJson(DateTimes.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }

    private static Slice toJson(String formatted) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(formatted.length() + 2);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(formatted);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", formatted, "json"));
        }
    }
}

