/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.trino.operator.aggregation.minmaxn.MinMaxNStateFactory;
import io.trino.operator.aggregation.minmaxn.MinNState;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.LongFunction;

public class MinNStateFactory
implements AccumulatorStateFactory<MinNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of min_n must be positive", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of min_n must be less than or equal to %s; found %s", 10000L, n);
        return new TypedHeap(true, readFlat, writeFlat, compareFlatFlat, compareFlatBlock, elementType, Math.toIntExact(n));
    };

    public MinNStateFactory(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle readFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle writeFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatBlock, @TypeParameter(value="T") Type elementType) {
    }

    public MinNState createSingleState() {
        return new SingleMinNState(this.heapFactory);
    }

    public MinNState createGroupedState() {
        return new GroupedMinNState(this.heapFactory);
    }

    private static class SingleMinNState
    extends MinMaxNStateFactory.SingleMinMaxNState
    implements MinNState {
        public SingleMinNState(LongFunction<TypedHeap> heapFactory) {
            super(heapFactory);
        }

        public SingleMinNState(SingleMinNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMinNState(this);
        }
    }

    private static class GroupedMinNState
    extends MinMaxNStateFactory.GroupedMinMaxNState
    implements MinNState {
        public GroupedMinNState(LongFunction<TypedHeap> heapFactory) {
            super(heapFactory);
        }
    }
}

