/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.airlift.configuration.Config;
import io.airlift.configuration.DefunctConfig;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"exchange.min-error-duration"})
public class DirectExchangeClientConfig {
    private DataSize maxBufferSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int concurrentRequestMultiplier = 3;
    private Duration maxErrorDuration = new Duration(1.0, TimeUnit.MINUTES);
    private DataSize maxResponseSize = new HttpClientConfig().getMaxContentLength();
    private int clientThreads = 25;
    private int pageBufferClientMaxCallbackThreads = 25;
    private boolean acknowledgePages = true;
    private DataSize deduplicationBufferSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @NotNull
    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Config(value="exchange.max-buffer-size")
    public DirectExchangeClientConfig setMaxBufferSize(DataSize maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConcurrentRequestMultiplier() {
        return this.concurrentRequestMultiplier;
    }

    @Config(value="exchange.concurrent-request-multiplier")
    public DirectExchangeClientConfig setConcurrentRequestMultiplier(int concurrentRequestMultiplier) {
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getMaxErrorDuration() {
        return this.maxErrorDuration;
    }

    @Config(value="exchange.max-error-duration")
    public DirectExchangeClientConfig setMaxErrorDuration(Duration maxErrorDuration) {
        this.maxErrorDuration = maxErrorDuration;
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    public @NotNull @MinDataSize(value="1MB") DataSize getMaxResponseSize() {
        return this.maxResponseSize;
    }

    @Config(value="exchange.max-response-size")
    public DirectExchangeClientConfig setMaxResponseSize(DataSize maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getClientThreads() {
        return this.clientThreads;
    }

    @Config(value="exchange.client-threads")
    public DirectExchangeClientConfig setClientThreads(int clientThreads) {
        this.clientThreads = clientThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPageBufferClientMaxCallbackThreads() {
        return this.pageBufferClientMaxCallbackThreads;
    }

    @Config(value="exchange.page-buffer-client.max-callback-threads")
    public DirectExchangeClientConfig setPageBufferClientMaxCallbackThreads(int pageBufferClientMaxCallbackThreads) {
        this.pageBufferClientMaxCallbackThreads = pageBufferClientMaxCallbackThreads;
        return this;
    }

    public boolean isAcknowledgePages() {
        return this.acknowledgePages;
    }

    @Config(value="exchange.acknowledge-pages")
    public DirectExchangeClientConfig setAcknowledgePages(boolean acknowledgePages) {
        this.acknowledgePages = acknowledgePages;
        return this;
    }

    @NotNull
    public DataSize getDeduplicationBufferSize() {
        return this.deduplicationBufferSize;
    }

    @Config(value="exchange.deduplication-buffer-size")
    public DirectExchangeClientConfig setDeduplicationBufferSize(DataSize deduplicationBufferSize) {
        this.deduplicationBufferSize = deduplicationBufferSize;
        return this;
    }
}

