/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.FormatMethod;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.FeaturesConfig;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.InternalFunctionDependencies;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class FunctionManager {
    private final NonEvictableCache<FunctionKey, ScalarFunctionImplementation> specializedScalarCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<ResolvedFunction, AggregationImplementation> specializedAggregationCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<ResolvedFunction, WindowFunctionSupplier> specializedWindowCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final CatalogServiceProvider<FunctionProvider> functionProviders;
    private final GlobalFunctionCatalog globalFunctionCatalog;
    private final LanguageFunctionProvider languageFunctionProvider;

    @Inject
    public FunctionManager(CatalogServiceProvider<FunctionProvider> functionProviders, GlobalFunctionCatalog globalFunctionCatalog, LanguageFunctionProvider languageFunctionProvider) {
        this.functionProviders = Objects.requireNonNull(functionProviders, "functionProviders is null");
        this.globalFunctionCatalog = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
        this.languageFunctionProvider = Objects.requireNonNull(languageFunctionProvider, "functionProvider is null");
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        try {
            return (ScalarFunctionImplementation)CacheUtils.uncheckedCacheGet(this.specializedScalarCache, (Object)new FunctionKey(resolvedFunction, invocationConvention), () -> this.getScalarFunctionImplementationInternal(resolvedFunction, invocationConvention));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private ScalarFunctionImplementation getScalarFunctionImplementationInternal(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        ScalarFunctionImplementation scalarFunctionImplementation;
        if (LanguageFunctionManager.isTrinoSqlLanguageFunction(resolvedFunction.functionId())) {
            scalarFunctionImplementation = this.languageFunctionProvider.specialize(resolvedFunction.functionId(), invocationConvention, this);
        } else {
            FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
            scalarFunctionImplementation = this.getFunctionProvider(resolvedFunction).getScalarFunctionImplementation(resolvedFunction.functionId(), resolvedFunction.signature(), functionDependencies, invocationConvention);
        }
        FunctionManager.verifyMethodHandleSignature(resolvedFunction.signature(), scalarFunctionImplementation, invocationConvention);
        return scalarFunctionImplementation;
    }

    public AggregationImplementation getAggregationImplementation(ResolvedFunction resolvedFunction) {
        try {
            return (AggregationImplementation)CacheUtils.uncheckedCacheGet(this.specializedAggregationCache, (Object)resolvedFunction, () -> this.getAggregationImplementationInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private AggregationImplementation getAggregationImplementationInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.getFunctionProvider(resolvedFunction).getAggregationImplementation(resolvedFunction.functionId(), resolvedFunction.signature(), functionDependencies);
    }

    public WindowFunctionSupplier getWindowFunctionSupplier(ResolvedFunction resolvedFunction) {
        try {
            return (WindowFunctionSupplier)CacheUtils.uncheckedCacheGet(this.specializedWindowCache, (Object)resolvedFunction, () -> this.getWindowFunctionSupplierInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier getWindowFunctionSupplierInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.getFunctionProvider(resolvedFunction).getWindowFunctionSupplier(resolvedFunction.functionId(), resolvedFunction.signature(), functionDependencies);
    }

    public TableFunctionProcessorProvider getTableFunctionProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        GlobalFunctionCatalog provider;
        CatalogHandle catalogHandle = tableFunctionHandle.catalogHandle();
        if (catalogHandle.equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            provider = this.globalFunctionCatalog;
        } else {
            provider = this.functionProviders.getService(catalogHandle);
            Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No function provider for catalog: '%s'", (Object)catalogHandle);
        }
        return provider.getTableFunctionProcessorProviderFactory(tableFunctionHandle.functionHandle()).createTableFunctionProcessorProvider();
    }

    private FunctionDependencies getFunctionDependencies(ResolvedFunction resolvedFunction) {
        return new InternalFunctionDependencies(this::getScalarFunctionImplementation, resolvedFunction.typeDependencies(), resolvedFunction.functionDependencies());
    }

    private FunctionProvider getFunctionProvider(ResolvedFunction resolvedFunction) {
        if (resolvedFunction.catalogHandle().equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            return this.globalFunctionCatalog;
        }
        FunctionProvider functionProvider = this.functionProviders.getService(resolvedFunction.catalogHandle());
        Preconditions.checkArgument((functionProvider != null ? 1 : 0) != 0, (String)"No function provider for catalog: '%s' (function '%s')", (Object)resolvedFunction.catalogHandle(), (Object)resolvedFunction.signature().getName());
        return functionProvider;
    }

    private static void verifyMethodHandleSignature(BoundSignature boundSignature, ScalarFunctionImplementation scalarFunctionImplementation, InvocationConvention convention) {
        MethodHandle methodHandle = scalarFunctionImplementation.getMethodHandle();
        MethodType methodType = methodHandle.type();
        Preconditions.checkArgument((convention.getArgumentConventions().size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Expected %s arguments, but got %s", (int)boundSignature.getArgumentTypes().size(), (int)convention.getArgumentConventions().size());
        long expectedParameterCount = convention.getArgumentConventions().stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
        expectedParameterCount += methodType.parameterList().stream().filter(ConnectorSession.class::equals).count();
        expectedParameterCount += (long)convention.getReturnConvention().getParameterCount();
        if (scalarFunctionImplementation.getInstanceFactory().isPresent()) {
            ++expectedParameterCount;
        }
        Preconditions.checkArgument((expectedParameterCount == (long)methodType.parameterCount() ? 1 : 0) != 0, (String)"Expected %s method parameters, but got %s", (long)expectedParameterCount, (int)methodType.parameterCount());
        int parameterIndex = 0;
        if (scalarFunctionImplementation.getInstanceFactory().isPresent()) {
            FunctionManager.verifyFunctionSignature(convention.supportsInstanceFactory(), "Method requires instance factory, but calling convention does not support an instance factory", new Object[0]);
            MethodHandle factoryMethod = (MethodHandle)scalarFunctionImplementation.getInstanceFactory().orElseThrow();
            FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex).equals(factoryMethod.type().returnType()), "Invalid return type", new Object[0]);
            ++parameterIndex;
        }
        int lambdaArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < boundSignature.getArgumentTypes().size(); ++argumentIndex) {
            while (methodType.parameterType(parameterIndex).equals(ConnectorSession.class)) {
                FunctionManager.verifyFunctionSignature(convention.supportsSession(), "Method requires session, but calling convention does not support session", new Object[0]);
                ++parameterIndex;
            }
            TypeDescriptor.OfField parameterType = methodType.parameterType(parameterIndex);
            Type argumentType = (Type)boundSignature.getArgumentTypes().get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(argumentIndex);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType, parameterType);
                    break;
                }
                case NULL_FLAG: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType.getJavaType(), parameterType);
                    FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex + 1).equals(Boolean.TYPE), "Expected null flag parameter to be followed by a boolean parameter", new Object[0]);
                    break;
                }
                case BOXED_NULLABLE: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(Primitives.wrap((Class)argumentType.getJavaType())), "Expected argument type to be %s, but is %s", Primitives.wrap((Class)argumentType.getJavaType()), parameterType);
                    break;
                }
                case BLOCK_POSITION_NOT_NULL: 
                case BLOCK_POSITION: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(Block.class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected %s argument types to be Block and int", argumentConvention);
                    break;
                }
                case VALUE_BLOCK_POSITION: 
                case VALUE_BLOCK_POSITION_NOT_NULL: {
                    FunctionManager.verifyFunctionSignature(ValueBlock.class.isAssignableFrom((Class<?>)parameterType) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected %s argument types to be ValueBlock and int", argumentConvention);
                    break;
                }
                case FLAT: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(byte[].class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE) && methodType.parameterType(parameterIndex + 2).equals(byte[].class), "Expected FLAT argument types to be byte[], int, byte[]", new Object[0]);
                    break;
                }
                case IN_OUT: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(InOut.class), "Expected IN_OUT argument type to be InOut", new Object[0]);
                    break;
                }
                case FUNCTION: {
                    Class lambdaInterface = (Class)scalarFunctionImplementation.getLambdaInterfaces().get(lambdaArgumentIndex);
                    FunctionManager.verifyFunctionSignature(parameterType.equals(lambdaInterface), "Expected function interface to be %s, but is %s", lambdaInterface, parameterType);
                    ++lambdaArgumentIndex;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown argument convention: " + String.valueOf(argumentConvention));
                }
            }
            parameterIndex += argumentConvention.getParameterCount();
        }
        Type returnType = boundSignature.getReturnType();
        switch (convention.getReturnConvention()) {
            case FAIL_ON_NULL: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(returnType.getJavaType()), "Expected return type to be %s, but is %s", returnType.getJavaType(), methodType.returnType());
                break;
            }
            case NULLABLE_RETURN: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(Primitives.wrap((Class)returnType.getJavaType())), "Expected return type to be %s, but is %s", returnType.getJavaType(), Primitives.wrap((Class)methodType.returnType()));
                break;
            }
            case BLOCK_BUILDER: {
                FunctionManager.verifyFunctionSignature(methodType.lastParameterType().equals(BlockBuilder.class), "Expected last argument type to be BlockBuilder, but is %s", methodType.lastParameterType());
                FunctionManager.verifyFunctionSignature(methodType.returnType().equals(Void.TYPE), "Expected return type to be void, but is %s", methodType.returnType());
                break;
            }
            case FLAT_RETURN: {
                List<Class<?>> parameters = methodType.parameterList();
                parameters = parameters.subList(parameters.size() - 4, parameters.size());
                FunctionManager.verifyFunctionSignature(parameters.equals(List.of(byte[].class, Integer.TYPE, byte[].class, Integer.TYPE)), "Expected last argument types to be (byte[], int, byte[], int), but is %s", methodType);
                FunctionManager.verifyFunctionSignature(methodType.returnType().equals(Void.TYPE), "Expected return type to be void, but is %s", methodType.returnType());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown return convention: " + String.valueOf(convention.getReturnConvention()));
            }
        }
    }

    @FormatMethod
    private static void verifyFunctionSignature(boolean check, String message, Object ... args) {
        if (!check) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format(message, args));
        }
    }

    public static FunctionManager createTestingFunctionManager() {
        return FunctionManager.createTestingFunctionManager(new InternalFunctionBundle(new SqlFunction[0]));
    }

    public static FunctionManager createTestingFunctionManager(FunctionBundle functionBundle) {
        TypeOperators typeOperators = new TypeOperators();
        GlobalFunctionCatalog functionCatalog = new GlobalFunctionCatalog((Provider<Metadata>)((Provider)() -> {
            throw new UnsupportedOperationException();
        }), (Provider<TypeManager>)((Provider)() -> {
            throw new UnsupportedOperationException();
        }), (Provider<FunctionManager>)((Provider)() -> {
            throw new UnsupportedOperationException();
        }));
        functionCatalog.addFunctions(SystemFunctionBundle.create(new FeaturesConfig(), typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN));
        functionCatalog.addFunctions(functionBundle);
        return new FunctionManager(CatalogServiceProvider.fail(), functionCatalog, LanguageFunctionProvider.DISABLED);
    }

    private record FunctionKey(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        private FunctionKey {
            Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        }
    }
}

