/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InternalNode;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class RemoteNodeMemory {
    private static final Logger log = Logger.get(RemoteNodeMemory.class);
    private final InternalNode node;
    private final HttpClient httpClient;
    private final URI memoryInfoUri;
    private final JsonCodec<MemoryInfo> memoryInfoCodec;
    private final AtomicReference<Optional<MemoryInfo>> memoryInfo = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();

    public RemoteNodeMemory(InternalNode node, HttpClient httpClient, JsonCodec<MemoryInfo> memoryInfoCodec, URI memoryInfoUri) {
        this.node = Objects.requireNonNull(node, "node is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.memoryInfoUri = Objects.requireNonNull(memoryInfoUri, "memoryInfoUri is null");
        this.memoryInfoCodec = Objects.requireNonNull(memoryInfoCodec, "memoryInfoCodec is null");
    }

    public Optional<MemoryInfo> getInfo() {
        return this.memoryInfo.get();
    }

    public InternalNode getNode() {
        return this.node;
    }

    public void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Memory info update request to %s has not returned in %s", new Object[]{this.memoryInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = Request.Builder.prepareGet().setUri(this.memoryInfoUri).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.memoryInfoCodec));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<MemoryInfo>>(this){
                final /* synthetic */ RemoteNodeMemory this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<MemoryInfo> result) {
                    this.this$0.lastUpdateNanos.set(System.nanoTime());
                    this.this$0.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                    if (result != null) {
                        if (result.hasValue()) {
                            this.this$0.memoryInfo.set(Optional.ofNullable((MemoryInfo)result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching memory info from %s returned status %d", new Object[]{this.this$0.memoryInfoUri, result.getStatusCode()});
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching memory info from %s: %s", new Object[]{this.this$0.memoryInfoUri, t.getMessage()});
                    this.this$0.lastUpdateNanos.set(System.nanoTime());
                    this.this$0.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

