/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Preconditions;
import io.trino.likematcher.DFA;
import io.trino.likematcher.Matcher;
import io.trino.likematcher.NFA;
import io.trino.likematcher.Pattern;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class DenseDfaMatcher
implements Matcher {
    public static final int FAIL_STATE = -1;
    private final List<Pattern> pattern;
    private final int start;
    private final int end;
    private final boolean exact;
    private volatile DenseDfa matcher;

    public DenseDfaMatcher(List<Pattern> pattern, int start, int end, boolean exact) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.start = start;
        this.end = end;
        this.exact = exact;
    }

    @Override
    public boolean match(byte[] input, int offset, int length) {
        DenseDfa matcher = this.matcher;
        if (matcher == null) {
            this.matcher = matcher = DenseDfa.newInstance(this.pattern, this.start, this.end);
        }
        if (this.exact) {
            return matcher.exactMatch(input, offset, length);
        }
        return matcher.prefixMatch(input, offset, length);
    }

    private static class DenseDfa {
        private final int[] transitions;
        private final int start;
        private final boolean[] accept;

        public static DenseDfa newInstance(List<Pattern> pattern, int start, int end) {
            DFA dfa = DenseDfa.makeNfa(pattern, start, end).toDfa();
            int[] transitions = new int[dfa.transitions().size() * 256];
            Arrays.fill(transitions, -1);
            for (int state = 0; state < dfa.transitions().size(); ++state) {
                for (DFA.Transition transition : dfa.transitions().get(state)) {
                    transitions[state * 256 + transition.value()] = transition.target() * 256;
                }
            }
            boolean[] accept = new boolean[dfa.transitions().size()];
            IntListIterator intListIterator = dfa.acceptStates().iterator();
            while (intListIterator.hasNext()) {
                int state = (Integer)intListIterator.next();
                accept[state] = true;
            }
            return new DenseDfa(transitions, dfa.start(), accept);
        }

        private DenseDfa(int[] transitions, int start, boolean[] accept) {
            this.transitions = transitions;
            this.start = start;
            this.accept = accept;
        }

        public boolean exactMatch(byte[] input, int offset, int length) {
            int state = this.start << 8;
            for (int i = offset; i < offset + length; ++i) {
                byte inputByte = input[i];
                if ((state = this.transitions[state | inputByte & 0xFF]) != -1) continue;
                return false;
            }
            return this.accept[state >>> 8];
        }

        public boolean prefixMatch(byte[] input, int offset, int length) {
            int state = this.start << 8;
            for (int i = offset; i < offset + length; ++i) {
                byte inputByte = input[i];
                if ((state = this.transitions[state | inputByte & 0xFF]) == -1) {
                    return false;
                }
                if (!this.accept[state >>> 8]) continue;
                return true;
            }
            return this.accept[state >>> 8];
        }

        private static NFA makeNfa(List<Pattern> pattern, int start, int end) {
            Preconditions.checkArgument((!pattern.isEmpty() ? 1 : 0) != 0, (Object)"pattern is empty");
            NFA.Builder builder = new NFA.Builder();
            int state = builder.addStartState();
            block5: for (int e = start; e <= end; ++e) {
                Pattern pattern2;
                Pattern item = pattern.get(e);
                Objects.requireNonNull(item);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Literal.class, Pattern.Any.class, Pattern.ZeroOrMore.class}, (Object)pattern2, n)) {
                    case 0: {
                        Pattern.Literal literal = (Pattern.Literal)pattern2;
                        for (byte current : literal.value().getBytes(StandardCharsets.UTF_8)) {
                            state = DenseDfa.matchByte(builder, state, current);
                        }
                        continue block5;
                    }
                    case 1: {
                        Pattern.Any any = (Pattern.Any)pattern2;
                        for (int i = 0; i < any.length(); ++i) {
                            int next = builder.addState();
                            DenseDfa.matchSingleUtf8(builder, state, next);
                            state = next;
                        }
                        continue block5;
                    }
                    case 2: {
                        Pattern.ZeroOrMore zeroOrMore = (Pattern.ZeroOrMore)pattern2;
                        DenseDfa.matchSingleUtf8(builder, state, state);
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported: " + item.getClass().getName());
                    }
                }
            }
            builder.setAccept(state);
            return builder.build();
        }

        private static int matchByte(NFA.Builder builder, int state, byte value) {
            int next = builder.addState();
            builder.addTransition(state, new NFA.Value(value), next);
            return next;
        }

        private static void matchSingleUtf8(NFA.Builder builder, int from, int to) {
            builder.addTransition(from, new NFA.Prefix(0, 1), to);
            int state1 = builder.addState();
            int state2 = builder.addState();
            int state3 = builder.addState();
            builder.addTransition(from, new NFA.Prefix(30, 5), state1);
            builder.addTransition(from, new NFA.Prefix(14, 4), state2);
            builder.addTransition(from, new NFA.Prefix(6, 3), state3);
            builder.addTransition(state1, new NFA.Prefix(2, 2), state2);
            builder.addTransition(state2, new NFA.Prefix(2, 2), state3);
            builder.addTransition(state3, new NFA.Prefix(2, 2), to);
        }
    }
}

