/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.google.common.collect.ImmutableList;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record IrArrayAccessor(IrPathNode base, List<Subscript> subscripts, Optional<Type> type) implements IrPathNode
{
    public IrArrayAccessor(IrPathNode base, List<Subscript> subscripts, Optional<Type> type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.base = Objects.requireNonNull(base, "array accessor base is null");
        this.subscripts = ImmutableList.copyOf(subscripts);
    }

    @Override
    public <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrArrayAccessor(this, context);
    }

    public record Subscript(IrPathNode from, Optional<IrPathNode> to) {
        public Subscript {
            Objects.requireNonNull(from, "from is null");
            Objects.requireNonNull(to, "to is null");
        }
    }
}

