/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.primitives.ImmutableLongArray;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.OutputDataSizeEstimate;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimatorFactory;
import java.util.Optional;
import java.util.function.Function;

public class ByTaskProgressOutputStatsEstimator
implements OutputStatsEstimator {
    private final double minSourceStageProgress;

    private ByTaskProgressOutputStatsEstimator(double minSourceStageProgress) {
        this.minSourceStageProgress = minSourceStageProgress;
    }

    @Override
    public Optional<OutputStatsEstimator.OutputStatsEstimateResult> getEstimatedOutputStats(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        if (!stageExecution.isNoMorePartitions()) {
            return Optional.empty();
        }
        int allPartitionsCount = stageExecution.getPartitionsCount();
        int remainingPartitionsCount = stageExecution.getRemainingPartitionsCount();
        if (remainingPartitionsCount == allPartitionsCount) {
            return Optional.empty();
        }
        double progress = (double)(allPartitionsCount - remainingPartitionsCount) / (double)allPartitionsCount;
        if (progress < this.minSourceStageProgress) {
            return Optional.empty();
        }
        long[] currentOutputDataSize = stageExecution.currentOutputDataSize();
        ImmutableLongArray.Builder estimateBuilder = ImmutableLongArray.builder((int)currentOutputDataSize.length);
        for (long partitionSize : currentOutputDataSize) {
            estimateBuilder.add((long)((double)partitionSize / progress));
        }
        long outputRowCountEstimate = (long)((double)stageExecution.getOutputRowCount() / progress);
        return Optional.of(new OutputStatsEstimator.OutputStatsEstimateResult(new OutputDataSizeEstimate(estimateBuilder.build()), outputRowCountEstimate, "BY_PROGRESS", true));
    }

    public static class Factory
    implements OutputStatsEstimatorFactory {
        @Override
        public OutputStatsEstimator create(Session session) {
            return new ByTaskProgressOutputStatsEstimator(SystemSessionProperties.getFaultTolerantExecutionMinSourceStageProgress(session));
        }
    }
}

