/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

@ThreadSafe
public class SpoolingOutputStats {
    private final int partitionCount;
    private volatile AtomicLongArray partitionDataSizes;
    private volatile Snapshot finalSnapshot;
    private volatile AtomicLong rowCount;

    public SpoolingOutputStats(int partitionCount) {
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be greater than zero");
        this.partitionCount = partitionCount;
        this.partitionDataSizes = new AtomicLongArray(partitionCount);
        this.rowCount = new AtomicLong();
    }

    public void updatePartitionDataSize(int partition, long dataSizeInBytes) {
        Preconditions.checkPositionIndex((int)partition, (int)this.partitionCount);
        Preconditions.checkArgument((dataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"dataSizeInBytes must be greater than or equal to zero");
        AtomicLongArray partitionDataSizes = this.partitionDataSizes;
        if (partitionDataSizes != null) {
            partitionDataSizes.addAndGet(partition, dataSizeInBytes);
        }
    }

    public void updateRowCount(int rowCount) {
        this.rowCount.addAndGet(rowCount);
    }

    public void finish() {
        AtomicLongArray partitionDataSizes = this.partitionDataSizes;
        this.partitionDataSizes = null;
        if (partitionDataSizes == null) {
            return;
        }
        this.finalSnapshot = SpoolingOutputStats.createSnapshot(partitionDataSizes, this.rowCount);
    }

    public Optional<Snapshot> getFinalSnapshot() {
        return Optional.ofNullable(this.finalSnapshot);
    }

    private static Snapshot createSnapshot(AtomicLongArray partitionDataSizes, AtomicLong rowCount) {
        int size = partitionDataSizes.length();
        Slice values = Slices.allocate((int)(2 * size));
        for (int i = 0; i < size; ++i) {
            values.setShort(2 * i, (int)SpoolingOutputStats.truncate(partitionDataSizes.get(i)));
        }
        return new Snapshot(values, rowCount.get());
    }

    private static short truncate(long value) {
        int floatBits = Float.floatToRawIntBits(value);
        floatBits <<= 1;
        return (short)(floatBits >>>= 16);
    }

    private static long expand(short value) {
        int floatBits = value & 0xFFFF;
        floatBits <<= 16;
        return Math.round((double)Float.intBitsToFloat(floatBits >>>= 1));
    }

    public static class Snapshot {
        private final Slice partitionDataSizes;
        private final long rowCount;

        @JsonCreator
        public Snapshot(@JsonProperty(value="partitionDataSizes") Slice partitionDataSizes, @JsonProperty(value="rowCount") long rowCount) {
            this.partitionDataSizes = Objects.requireNonNull(partitionDataSizes, "partitionDataSizes is null");
            this.rowCount = rowCount;
        }

        @JsonProperty
        public Slice getPartitionDataSizes() {
            return this.partitionDataSizes;
        }

        @JsonProperty
        public long getRowCount() {
            return this.rowCount;
        }

        public long getPartitionSizeInBytes(int partition) {
            int partitionCount = this.partitionDataSizes.length() / 2;
            Preconditions.checkArgument((partition < partitionCount ? 1 : 0) != 0, (String)"partition must be less than %s", (int)partitionCount);
            return SpoolingOutputStats.expand(this.partitionDataSizes.getShort(partition * 2));
        }
    }
}

