/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RevokeRoles;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RevokeRolesTask
implements DataDefinitionTask<RevokeRoles> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RevokeRolesTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "REVOKE ROLE";
    }

    @Override
    public ListenableFuture<Void> execute(RevokeRoles statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        Set roles = (Set)statement.getRoles().stream().map(role -> role.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        Set grantees = (Set)statement.getGrantees().stream().map(MetadataUtil::createPrincipal).collect(ImmutableSet.toImmutableSet());
        boolean adminOption = statement.isAdminOption();
        Optional<TrinoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, session, (Node)statement, statement.getCatalog().map(Identifier::getValue));
        LinkedHashSet<String> specifiedRoles = new LinkedHashSet<String>();
        specifiedRoles.addAll(roles);
        grantees.stream().filter(principal -> principal.getType() == PrincipalType.ROLE).map(TrinoPrincipal::getName).forEach(specifiedRoles::add);
        if (grantor.isPresent() && grantor.get().getType() == PrincipalType.ROLE) {
            specifiedRoles.add(grantor.get().getName());
        }
        for (String role2 : specifiedRoles) {
            MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, role2, catalog);
        }
        this.accessControl.checkCanRevokeRoles(session.toSecurityContext(), roles, grantees, adminOption, grantor, catalog);
        this.metadata.revokeRoles(session, roles, grantees, adminOption, grantor, catalog);
        return Futures.immediateVoidFuture();
    }
}

