/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.execution.BasicStageStats;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.TaskInfo;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class BasicStageInfo {
    private final StageId stageId;
    private final StageState state;
    private final boolean coordinatorOnly;
    private final List<BasicStageInfo> subStages;
    private final BasicStageStats stageStats;
    private final List<TaskInfo> tasks;

    @JsonCreator
    public BasicStageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="coordinatorOnly") boolean coordinatorOnly, @JsonProperty(value="stageStats") BasicStageStats stageStats, @JsonProperty(value="subStages") List<BasicStageInfo> subStages, @JsonProperty(value="tasks") List<TaskInfo> tasks) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.coordinatorOnly = coordinatorOnly;
        this.subStages = Objects.requireNonNull(subStages, "subStages is null");
        this.stageStats = Objects.requireNonNull(stageStats, "stageStats is null");
        this.tasks = Objects.requireNonNull(tasks, "tasks is null");
    }

    public BasicStageInfo(StageInfo stageInfo) {
        this(stageInfo.getStageId(), stageInfo.getState(), stageInfo.isCoordinatorOnly(), stageInfo.getStageStats().toBasicStageStats(stageInfo.getState()), stageInfo.getSubStages().stream().map(BasicStageInfo::new).toList(), stageInfo.getTasks());
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isCoordinatorOnly() {
        return this.coordinatorOnly;
    }

    @JsonProperty
    public BasicStageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<BasicStageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    public boolean isFinalStageInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.taskStatus().getState().isDone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public static List<BasicStageInfo> getAllStages(Optional<BasicStageInfo> stageInfo) {
        return stageInfo.map(BasicStageInfo::getAllStages).orElseGet(ImmutableList::of);
    }

    public static List<BasicStageInfo> getAllStages(BasicStageInfo stageInfo) {
        ImmutableList.Builder collector = ImmutableList.builder();
        BasicStageInfo.addAllStages(stageInfo, (ImmutableList.Builder<BasicStageInfo>)collector);
        return collector.build();
    }

    private static void addAllStages(@Nullable BasicStageInfo stage, ImmutableList.Builder<BasicStageInfo> collector) {
        if (stage != null) {
            collector.add((Object)stage);
            for (BasicStageInfo subStage : stage.getSubStages()) {
                BasicStageInfo.addAllStages(subStage, collector);
            }
        }
    }
}

