/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final ColumnPropertyManager columnPropertyManager;

    @Inject
    public AddColumnTask(PlannerContext plannerContext, AccessControl accessControl, ColumnPropertyManager columnPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
    }

    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<Void> execute(AddColumn statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Type type;
        Session session = stateMachine.getSession();
        QualifiedObjectName originalTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.plannerContext.getMetadata().getRedirectionAwareTableHandle(session, originalTableName);
        if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", originalTableName);
            }
            return Futures.immediateVoidFuture();
        }
        TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
        CatalogHandle catalogHandle = tableHandle.catalogHandle();
        QualifiedObjectName qualifiedTableName = redirectionAwareTableHandle.redirectedTableName().orElse(originalTableName);
        Map<String, ColumnHandle> columnHandles = this.plannerContext.getMetadata().getColumnHandles(session, tableHandle);
        ColumnDefinition element = statement.getColumn();
        Identifier columnName = (Identifier)element.getName().getOriginalParts().get(0);
        try {
            type = this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(element.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), columnName);
        }
        if (element.getName().getParts().size() == 1) {
            this.accessControl.checkCanAddColumns(session.toSecurityContext(), qualifiedTableName);
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), columnName);
            }
            if (columnHandles.containsKey(columnName.getValue().toLowerCase(Locale.ENGLISH))) {
                if (!statement.isColumnNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", columnName);
                }
                return Futures.immediateVoidFuture();
            }
            if (!element.isNullable() && !this.plannerContext.getMetadata().getConnectorCapabilities(session, catalogHandle).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", catalogHandle, columnName);
            }
            Map columnProperties = this.columnPropertyManager.getProperties(catalogHandle.getCatalogName().toString(), catalogHandle, (Iterable)element.getProperties(), session, this.plannerContext, this.accessControl, (Map)ParameterExtractor.bindParameters((Statement)statement, parameters), true);
            ColumnMetadata column = ColumnMetadata.builder().setName(columnName.getValue()).setType(type).setNullable(element.isNullable()).setComment(element.getComment()).setProperties(columnProperties).build();
            this.plannerContext.getMetadata().addColumn(session, tableHandle, qualifiedTableName.asCatalogSchemaTableName(), column);
        } else {
            this.accessControl.checkCanAlterColumn(session.toSecurityContext(), qualifiedTableName);
            if (!columnHandles.containsKey(columnName.getValue().toLowerCase(Locale.ENGLISH))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", columnName);
            }
            List parentPath = (List)statement.getColumn().getName().getOriginalParts().subList(0, statement.getColumn().getName().getOriginalParts().size() - 1).stream().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
            List fieldPath = (List)statement.getColumn().getName().getOriginalParts().subList(1, statement.getColumn().getName().getOriginalParts().size()).stream().map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            ColumnMetadata columnMetadata = this.plannerContext.getMetadata().getColumnMetadata(session, tableHandle, columnHandles.get(columnName.getValue().toLowerCase(Locale.ENGLISH)));
            Type currentType = columnMetadata.getType();
            for (int i = 0; i < fieldPath.size() - 1; ++i) {
                String fieldName = (String)fieldPath.get(i);
                List<RowType.Field> candidates = AddColumnTask.getCandidates(currentType, fieldName);
                if (candidates.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Field '%s' does not exist within %s", fieldName, currentType);
                }
                if (candidates.size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)statement, "Field path %s within %s is ambiguous", fieldPath, columnMetadata.getType());
                }
                currentType = ((RowType.Field)Iterables.getOnlyElement(candidates)).getType();
            }
            String fieldName = (String)Iterables.getLast((Iterable)statement.getColumn().getName().getParts());
            List<RowType.Field> candidates = AddColumnTask.getCandidates(currentType, fieldName);
            if (!candidates.isEmpty()) {
                if (statement.isColumnNotExists()) {
                    return Futures.immediateVoidFuture();
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Field '%s' already exists", fieldName);
            }
            this.plannerContext.getMetadata().addField(session, tableHandle, parentPath, fieldName, type, statement.isColumnNotExists());
        }
        return Futures.immediateVoidFuture();
    }

    private static List<RowType.Field> getCandidates(Type type, String fieldName) {
        if (!(type instanceof RowType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
        }
        RowType rowType = (RowType)type;
        List candidates = (List)rowType.getFields().stream().filter(rowField -> rowField.getName().isPresent() && ((String)rowField.getName().get()).equalsIgnoreCase(fieldName)).collect(ImmutableList.toImmutableList());
        return candidates;
    }
}

