/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SampleNode;
import java.util.Optional;

public class SampleStatsRule
extends SimpleStatsRule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample();

    public SampleStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(SampleNode node, StatsCalculator.Context context) {
        PlanNodeStatsEstimate sourceStats = context.statsProvider().getStats(node.getSource());
        PlanNodeStatsEstimate calculatedStats = sourceStats.mapOutputRowCount(outputRowCount -> outputRowCount * node.getSampleRatio());
        return Optional.of(calculatedStats);
    }
}

