/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProjectStatsRule
extends SimpleStatsRule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project();
    private final ScalarStatsCalculator scalarStatsCalculator;

    public ProjectStatsRule(ScalarStatsCalculator scalarStatsCalculator, StatsNormalizer normalizer) {
        super(normalizer);
        this.scalarStatsCalculator = Objects.requireNonNull(scalarStatsCalculator, "scalarStatsCalculator is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(ProjectNode node, StatsCalculator.Context context) {
        PlanNodeStatsEstimate sourceStats = context.statsProvider().getStats(node.getSource());
        PlanNodeStatsEstimate.Builder calculatedStats = PlanNodeStatsEstimate.builder().setOutputRowCount(sourceStats.getOutputRowCount());
        for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
            calculatedStats.addSymbolStatistics(entry.getKey(), this.scalarStatsCalculator.calculate(entry.getValue(), sourceStats, context.session()));
        }
        return Optional.of(calculatedStats.build());
    }
}

