/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Verify;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Memo;
import io.trino.sql.planner.plan.PlanNode;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CachingStatsProvider
implements StatsProvider {
    private static final Logger log = Logger.get(CachingStatsProvider.class);
    private final StatsCalculator statsCalculator;
    private final Optional<Memo> memo;
    private final Lookup lookup;
    private final Session session;
    private final TableStatsProvider tableStatsProvider;
    private final RuntimeInfoProvider runtimeInfoProvider;
    private final Map<PlanNode, PlanNodeStatsEstimate> cache = new IdentityHashMap<PlanNode, PlanNodeStatsEstimate>();

    public CachingStatsProvider(StatsCalculator statsCalculator, Session session, TableStatsProvider tableStatsProvider) {
        this(statsCalculator, Optional.empty(), Lookup.noLookup(), session, tableStatsProvider, RuntimeInfoProvider.noImplementation());
    }

    public CachingStatsProvider(StatsCalculator statsCalculator, Optional<Memo> memo, Lookup lookup, Session session, TableStatsProvider tableStatsProvider, RuntimeInfoProvider runtimeInfoProvider) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.memo = Objects.requireNonNull(memo, "memo is null");
        this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableStatsProvider = Objects.requireNonNull(tableStatsProvider, "tableStatsProvider is null");
        this.runtimeInfoProvider = Objects.requireNonNull(runtimeInfoProvider, "runtimeInfoProvider is null");
    }

    @Override
    public PlanNodeStatsEstimate getStats(PlanNode node) {
        if (!SystemSessionProperties.isEnableStatsCalculator(this.session)) {
            return PlanNodeStatsEstimate.unknown();
        }
        Objects.requireNonNull(node, "node is null");
        try {
            if (node instanceof GroupReference) {
                GroupReference group = (GroupReference)node;
                return this.getGroupStats(group);
            }
            PlanNodeStatsEstimate stats = this.cache.get(node);
            if (stats != null) {
                return stats;
            }
            stats = this.statsCalculator.calculateStats(node, new StatsCalculator.Context(this, this.lookup, this.session, this.tableStatsProvider, this.runtimeInfoProvider));
            Verify.verify((this.cache.put(node, stats) == null ? 1 : 0) != 0, (String)"Stats already set", (Object[])new Object[0]);
            return stats;
        }
        catch (RuntimeException e) {
            if (SystemSessionProperties.isIgnoreStatsCalculatorFailures(this.session)) {
                log.error((Throwable)e, "Error occurred when computing stats for query %s", new Object[]{this.session.getQueryId()});
                return PlanNodeStatsEstimate.unknown();
            }
            throw e;
        }
    }

    private PlanNodeStatsEstimate getGroupStats(GroupReference groupReference) {
        int group = groupReference.getGroupId();
        Memo memo = this.memo.orElseThrow(() -> new IllegalStateException("CachingStatsProvider without memo cannot handle GroupReferences"));
        Optional<PlanNodeStatsEstimate> stats = memo.getStats(group);
        if (stats.isPresent()) {
            return stats.get();
        }
        PlanNodeStatsEstimate groupStats = this.getStats(memo.getNode(group));
        Verify.verify((boolean)memo.getStats(group).isEmpty(), (String)"Group stats already set", (Object[])new Object[0]);
        memo.storeStats(group, groupStats);
        return groupStats;
    }
}

