/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SystemSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SystemSplit.class);
    private final List<HostAddress> addresses;
    private final TupleDomain<ColumnHandle> constraint;

    public SystemSplit(HostAddress address, TupleDomain<ColumnHandle> constraint) {
        this((List<HostAddress>)ImmutableList.of((Object)Objects.requireNonNull(address, "address is null")), constraint);
    }

    @JsonCreator
    public SystemSplit(@JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        Objects.requireNonNull(addresses, "addresses is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"addresses is empty");
        this.addresses = ImmutableList.copyOf(addresses);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"addresses", (Object)this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + this.constraint.getRetainedSizeInBytes(columnHandle -> ((SystemColumnHandle)columnHandle).getRetainedSizeInBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).toString();
    }
}

