/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal.OkHttpAttributesGetter;
import java.util.List;
import java.util.function.Consumer;

public final class OkHttpInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.okhttp-3.0";

    public static Instrumenter<Request, Response> create(OpenTelemetry openTelemetry, Consumer<HttpClientAttributesExtractorBuilder<Request, Response>> extractorConfigurer, Consumer<HttpSpanNameExtractorBuilder<Request>> spanNameExtractorConfigurer, List<AttributesExtractor<Request, Response>> additionalAttributesExtractors, boolean emitExperimentalHttpClientMetrics) {
        OkHttpAttributesGetter httpAttributesGetter = OkHttpAttributesGetter.INSTANCE;
        HttpClientAttributesExtractorBuilder extractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept((HttpClientAttributesExtractorBuilder<Request, Response>)extractorBuilder);
        HttpSpanNameExtractorBuilder httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        spanNameExtractorConfigurer.accept((HttpSpanNameExtractorBuilder<Request>)httpSpanNameExtractorBuilder);
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)httpSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(extractorBuilder.build()).addAttributesExtractors(additionalAttributesExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private OkHttpInstrumenterFactory() {
    }
}

