/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.client.ClientTypeSignatureParameter;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.NamedClientTypeSignature;
import io.trino.jdbc.$internal.client.Row;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class JsonDecodingUtils {
    private JsonDecodingUtils() {
    }

    static TypeDecoder[] createTypeDecoders(List<Column> columns) {
        Verify.verify(!columns.isEmpty(), "Columns must not be empty", new Object[0]);
        return (TypeDecoder[])columns.stream().map(column -> JsonDecodingUtils.createTypeDecoder(column.getTypeSignature())).toArray(TypeDecoder[]::new);
    }

    private static TypeDecoder createTypeDecoder(ClientTypeSignature signature) {
        switch (signature.getRawType()) {
            case "bigint": {
                return new BigIntegerDecoder();
            }
            case "integer": {
                return new IntegerDecoder();
            }
            case "smallint": {
                return new SmallintDecoder();
            }
            case "tinyint": {
                return new TinyintDecoder();
            }
            case "double": {
                return new DoubleDecoder();
            }
            case "real": {
                return new RealDecoder();
            }
            case "boolean": {
                return new BooleanDecoder();
            }
            case "array": {
                return new ArrayDecoder(signature);
            }
            case "map": {
                return new MapDecoder(signature);
            }
            case "row": {
                return new RowDecoder(signature);
            }
            case "varchar": 
            case "json": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": 
            case "ipaddress": 
            case "uuid": 
            case "decimal": 
            case "char": 
            case "Geometry": 
            case "SphericalGeography": {
                return new StringDecoder();
            }
        }
        return new Base64Decoder();
    }

    private static IllegalTokenException illegalToken(JsonParser parser) {
        throw new IllegalTokenException(parser);
    }

    static interface TypeDecoder {
        public Object decode(JsonParser var1) throws IOException;
    }

    private static class IllegalTokenException
    extends RuntimeException {
        public IllegalTokenException(JsonParser parser) {
            super(String.format("Unexpected token %s [location: %s]", new Object[]{parser.currentToken(), parser.currentLocation()}));
        }
    }

    private static class BigIntegerDecoder
    implements TypeDecoder {
        private BigIntegerDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_INT: {
                    return parser.getLongValue();
                }
                case VALUE_STRING: {
                    return Long.parseLong(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class IntegerDecoder
    implements TypeDecoder {
        private IntegerDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_INT: {
                    return parser.getIntValue();
                }
                case VALUE_STRING: {
                    return Integer.parseInt(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class SmallintDecoder
    implements TypeDecoder {
        private SmallintDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_INT: {
                    return parser.getShortValue();
                }
                case VALUE_STRING: {
                    return Short.parseShort(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class TinyintDecoder
    implements TypeDecoder {
        private TinyintDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_INT: {
                    return parser.getByteValue();
                }
                case VALUE_STRING: {
                    return Byte.parseByte(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class DoubleDecoder
    implements TypeDecoder {
        private DoubleDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_FLOAT: {
                    return parser.getDoubleValue();
                }
                case VALUE_STRING: {
                    return Double.parseDouble(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class RealDecoder
    implements TypeDecoder {
        private RealDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_NUMBER_FLOAT: {
                    return Float.valueOf(parser.getFloatValue());
                }
                case VALUE_STRING: {
                    return Float.valueOf(Float.parseFloat(parser.getValueAsString()));
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class BooleanDecoder
    implements TypeDecoder {
        private BooleanDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_FALSE: {
                    return false;
                }
                case VALUE_TRUE: {
                    return true;
                }
                case VALUE_STRING: {
                    return Boolean.parseBoolean(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class ArrayDecoder
    implements TypeDecoder {
        private final TypeDecoder typeDecoder;

        public ArrayDecoder(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("array"), "not an array type signature: %s", (Object)signature);
            this.typeDecoder = JsonDecodingUtils.createTypeDecoder(signature.getArgumentsAsTypeSignatures().get(0));
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case START_ARRAY: {
                    break;
                }
                case VALUE_NULL: {
                    return null;
                }
                default: {
                    throw JsonDecodingUtils.illegalToken(parser);
                }
            }
            LinkedList<Object> values2 = new LinkedList<Object>();
            block8: while (true) {
                switch (parser.nextToken()) {
                    case END_ARRAY: {
                        return Collections.unmodifiableList(values2);
                    }
                    case VALUE_NULL: {
                        values2.add(null);
                        continue block8;
                    }
                }
                values2.add(this.typeDecoder.decode(parser));
            }
        }
    }

    private static class MapDecoder
    implements TypeDecoder {
        private final String keyType;
        private final TypeDecoder valueDecoder;

        public MapDecoder(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("map"), "not a map type signature: %s", (Object)signature);
            this.keyType = signature.getArgumentsAsTypeSignatures().get(0).getRawType();
            this.valueDecoder = JsonDecodingUtils.createTypeDecoder(signature.getArgumentsAsTypeSignatures().get(1));
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            HashMap<Object, Object> values2 = new HashMap<Object, Object>();
            if (parser.currentToken() != JsonToken.START_OBJECT) {
                throw JsonDecodingUtils.illegalToken(parser);
            }
            block4: while (true) {
                switch (parser.nextToken()) {
                    case FIELD_NAME: {
                        Object name = this.decodeKey(parser.getValueAsString());
                        if (Objects.requireNonNull(parser.nextToken()) == JsonToken.VALUE_NULL) {
                            values2.put(name, null);
                            continue block4;
                        }
                        values2.put(name, this.valueDecoder.decode(parser));
                        continue block4;
                    }
                    case END_OBJECT: {
                        return Collections.unmodifiableMap(values2);
                    }
                }
                JsonDecodingUtils.illegalToken(parser);
            }
        }

        private Object decodeKey(String value) {
            switch (this.keyType) {
                case "bigint": {
                    return Long.parseLong(value);
                }
                case "integer": {
                    return Integer.parseInt(value);
                }
                case "smallint": {
                    return Short.parseShort(value);
                }
                case "tinyint": {
                    return Byte.parseByte(value);
                }
                case "double": {
                    return Double.parseDouble(value);
                }
                case "real": {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case "boolean": {
                    return Boolean.parseBoolean(value);
                }
                case "varchar": 
                case "json": 
                case "time": 
                case "time with time zone": 
                case "timestamp": 
                case "timestamp with time zone": 
                case "date": 
                case "interval year to month": 
                case "interval day to second": 
                case "ipaddress": 
                case "uuid": 
                case "decimal": 
                case "char": 
                case "Geometry": 
                case "SphericalGeography": {
                    return value;
                }
            }
            return Base64.getDecoder().decode(value);
        }
    }

    private static class RowDecoder
    implements TypeDecoder {
        private final TypeDecoder[] fieldDecoders;
        private final List<Optional<String>> fieldNames;

        private RowDecoder(ClientTypeSignature signature) {
            Objects.requireNonNull(signature, "signature is null");
            Preconditions.checkArgument(signature.getRawType().equals("row"), "not a row type signature: %s", (Object)signature);
            this.fieldDecoders = new TypeDecoder[signature.getArguments().size()];
            ImmutableList.Builder fieldNames = ImmutableList.builderWithExpectedSize(this.fieldDecoders.length);
            int index = 0;
            for (ClientTypeSignatureParameter parameter : signature.getArguments()) {
                Preconditions.checkArgument(parameter.getKind() == ClientTypeSignatureParameter.ParameterKind.NAMED_TYPE, "Unexpected parameter [%s] for row type", (Object)parameter);
                NamedClientTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                this.fieldDecoders[index] = JsonDecodingUtils.createTypeDecoder(namedTypeSignature.getTypeSignature());
                fieldNames.add(namedTypeSignature.getName());
                ++index;
            }
            this.fieldNames = fieldNames.build();
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case START_ARRAY: {
                    break;
                }
                case VALUE_NULL: {
                    return null;
                }
                default: {
                    throw JsonDecodingUtils.illegalToken(parser);
                }
            }
            Row.Builder row = Row.builderWithExpectedSize(this.fieldDecoders.length);
            for (int i = 0; i < this.fieldDecoders.length; ++i) {
                if (Objects.requireNonNull(parser.nextToken()) == JsonToken.VALUE_NULL) {
                    row.addField(this.fieldNames.get(i), null);
                    continue;
                }
                row.addField(this.fieldNames.get(i), this.fieldDecoders[i].decode(parser));
            }
            Verify.verify(parser.nextToken() == JsonToken.END_ARRAY, "Expected end object, but got %s", (Object)parser.currentToken());
            return row.build();
        }
    }

    private static class StringDecoder
    implements TypeDecoder {
        private StringDecoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return parser.getValueAsString();
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }

    private static class Base64Decoder
    implements TypeDecoder {
        private Base64Decoder() {
        }

        @Override
        public Object decode(JsonParser parser) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return Base64.getDecoder().decode(parser.getValueAsString());
                }
            }
            throw JsonDecodingUtils.illegalToken(parser);
        }
    }
}

