/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.esri.core.geometry.Envelope;
import io.airlift.slice.Slice;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.geospatial.Rectangle;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.plugin.geospatial.SpatialPartitioningState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@AggregationFunction(value="spatial_partitioning", decomposable=false, hidden=true)
public final class SpatialPartitioningInternalAggregateFunction {
    private static final int MAX_SAMPLE_COUNT = 1000000;

    private SpatialPartitioningInternalAggregateFunction() {
    }

    @InputFunction
    public static void input(SpatialPartitioningState state, @SqlType(value="Geometry") Slice slice, @SqlType(value="integer") long partitionCount) {
        Envelope envelope = GeometrySerde.deserializeEnvelope((Slice)slice);
        if (envelope.isEmpty()) {
            return;
        }
        Rectangle extent = new Rectangle(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax());
        if (state.getCount() == 0L) {
            state.setPartitionCount(Math.toIntExact(partitionCount));
            state.setExtent(extent);
            state.setSamples(new ArrayList<Rectangle>());
        } else {
            state.setExtent(state.getExtent().merge(extent));
        }
        List<Rectangle> samples = state.getSamples();
        if (samples.size() <= 1000000) {
            samples.add(extent);
        } else {
            long sampleIndex = ThreadLocalRandom.current().nextLong(state.getCount());
            if (sampleIndex < 1000000L) {
                samples.set(Math.toIntExact(sampleIndex), extent);
            }
        }
        state.setCount(state.getCount() + 1L);
    }

    @OutputFunction(value="varchar")
    public static void output(SpatialPartitioningState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
            return;
        }
        List<Rectangle> samples = state.getSamples();
        int partitionCount = state.getPartitionCount();
        int maxItemsPerNode = (samples.size() + partitionCount - 1) / partitionCount;
        Rectangle envelope = state.getExtent();
        Rectangle paddedExtent = new Rectangle(envelope.getXMin(), envelope.getYMin(), Math.nextUp(envelope.getXMax()), Math.nextUp(envelope.getYMax()));
        VarcharType.VARCHAR.writeString(out, KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)maxItemsPerNode, (Rectangle)paddedExtent, samples)));
    }
}

