/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExampleSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ExampleSplit.class);
    private final String uri;
    private final boolean remotelyAccessible;
    private final List<HostAddress> addresses;

    @JsonCreator
    public ExampleSplit(@JsonProperty(value="uri") String uri) {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.remotelyAccessible = true;
        this.addresses = ImmutableList.of((Object)HostAddress.fromUri((URI)URI.create(uri)));
    }

    @JsonProperty
    public String getUri() {
        return this.uri;
    }

    public boolean isRemotelyAccessible() {
        return this.remotelyAccessible;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"addresses", (Object)this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(",")), (Object)"remotelyAccessible", (Object)String.valueOf(this.remotelyAccessible));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.uri) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }
}

