/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import io.trino.plugin.example.ExampleClient;
import io.trino.plugin.example.ExampleSplit;
import io.trino.plugin.example.ExampleTable;
import io.trino.plugin.example.ExampleTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.TableNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleClient exampleClient) {
        this.exampleClient = Objects.requireNonNull(exampleClient, "exampleClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        ExampleTableHandle tableHandle = (ExampleTableHandle)connectorTableHandle;
        ExampleTable table = this.exampleClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        ArrayList<ExampleSplit> splits = new ArrayList<ExampleSplit>();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(uri.toString()));
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

