/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class ExampleSplit
implements ConnectorSplit {
    private final URI uri;
    private final boolean remotelyAccessible;
    private final List<HostAddress> addresses;

    @JsonCreator
    public ExampleSplit(@JsonProperty(value="uri") URI uri) {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.remotelyAccessible = true;
        this.addresses = ImmutableList.of((Object)HostAddress.fromUri((URI)uri));
    }

    @JsonProperty
    public URI getUri() {
        return this.uri;
    }

    public boolean isRemotelyAccessible() {
        return this.remotelyAccessible;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

