/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli.lexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.cli.lexer.DelimiterLexer;
import io.trino.grammar.sql.SqlBaseBaseVisitor;
import io.trino.grammar.sql.SqlBaseParser;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class StatementSplitter {
    private final List<Statement> completeStatements;
    private final String partialStatement;

    public StatementSplitter(String sql) {
        this(sql, (Set<String>)ImmutableSet.of((Object)";"));
    }

    public StatementSplitter(String sql, Set<String> delimiters) {
        DelimiterLexer lexer = StatementSplitter.getLexer(sql, delimiters);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        tokenStream.fill();
        SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        ImmutableList.Builder list = ImmutableList.builder();
        StringBuilder sb = new StringBuilder();
        int index = 0;
        block0: while (index < tokenStream.size()) {
            Token stop;
            SqlBaseParser.StatementContext context = parser.statement();
            if (StatementSplitter.containsFunction((ParseTree)context) && (stop = context.getStop()) != null && stop.getTokenIndex() >= index) {
                int endIndex = stop.getTokenIndex();
                while (index <= endIndex) {
                    Token token = tokenStream.get(index);
                    ++index;
                    sb.append(token.getText());
                }
            }
            while (index < tokenStream.size()) {
                Token token = tokenStream.get(index);
                ++index;
                if (token.getType() == -1) continue block0;
                if (lexer.isDelimiter(token)) {
                    String statement = sb.toString().trim();
                    if (!statement.isEmpty()) {
                        list.add((Object)new Statement(statement, token.getText()));
                    }
                    sb = new StringBuilder();
                    continue block0;
                }
                sb.append(token.getText());
            }
        }
        this.completeStatements = list.build();
        this.partialStatement = sb.toString().trim();
    }

    public List<Statement> getCompleteStatements() {
        return this.completeStatements;
    }

    public String getPartialStatement() {
        return this.partialStatement;
    }

    public static String squeezeStatement(String sql) {
        Token token;
        DelimiterLexer tokens = StatementSplitter.getLexer(sql, (Set<String>)ImmutableSet.of());
        StringBuilder sb = new StringBuilder();
        while ((token = tokens.nextToken()).getType() != -1) {
            if (token.getType() == 341) {
                sb.append(' ');
                continue;
            }
            sb.append(token.getText());
        }
        return sb.toString().trim();
    }

    public static boolean isEmptyStatement(String sql) {
        Token token;
        DelimiterLexer tokens = StatementSplitter.getLexer(sql, (Set<String>)ImmutableSet.of());
        do {
            if ((token = tokens.nextToken()).getType() != -1) continue;
            return true;
        } while (token.getChannel() == 1);
        return false;
    }

    public static DelimiterLexer getLexer(String sql, Set<String> terminators) {
        Objects.requireNonNull(sql, "sql is null");
        return new DelimiterLexer((CharStream)CharStreams.fromString((String)sql), terminators);
    }

    private static boolean containsFunction(ParseTree tree) {
        return (Boolean)new SqlBaseBaseVisitor<Boolean>(){

            protected Boolean defaultResult() {
                return false;
            }

            protected Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
                return aggregate != false || nextResult != false;
            }

            protected boolean shouldVisitNextChild(RuleNode node, Boolean currentResult) {
                return currentResult == false;
            }

            public Boolean visitFunctionSpecification(SqlBaseParser.FunctionSpecificationContext context) {
                return true;
            }
        }.visit(tree);
    }

    public static class Statement {
        private final String statement;
        private final String terminator;

        public Statement(String statement, String terminator) {
            this.statement = Objects.requireNonNull(statement, "statement is null");
            this.terminator = Objects.requireNonNull(terminator, "terminator is null");
        }

        public String statement() {
            return this.statement;
        }

        public String terminator() {
            return this.terminator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Statement o = (Statement)obj;
            return Objects.equals(this.statement, o.statement) && Objects.equals(this.terminator, o.terminator);
        }

        public int hashCode() {
            return Objects.hash(this.statement, this.terminator);
        }

        public String toString() {
            return this.statement + this.terminator;
        }
    }
}

