/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.cli.FormatUtils;
import io.trino.cli.OutputPrinter;
import io.trino.client.Column;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jline.utils.AttributedString;
import org.jline.utils.WCWidth;

public class MarkdownTablePrinter
implements OutputPrinter {
    private static final Set<String> NUMERIC_TYPES = ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"real", (Object)"double", (Object[])new String[]{"decimal"});
    private final List<String> fieldNames;
    private final List<Align> alignments;
    private final Writer writer;
    private boolean headerRendered;

    public MarkdownTablePrinter(List<Column> columns, Writer writer) {
        Objects.requireNonNull(columns, "columns is null");
        this.fieldNames = (List)columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        this.alignments = (List)columns.stream().map(Column::getTypeSignature).map(signature -> NUMERIC_TYPES.contains(signature.getRawType()) ? Align.RIGHT : Align.LEFT).collect(ImmutableList.toImmutableList());
        this.writer = Objects.requireNonNull(writer, "writer is null");
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        int columns = this.fieldNames.size();
        int[] columnWidth = new int[columns];
        for (int i = 0; i < columns; ++i) {
            columnWidth[i] = Math.max(1, MarkdownTablePrinter.consoleWidth(this.fieldNames.get(i)));
        }
        for (List<?> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                String s = MarkdownTablePrinter.formatValue(row.get(i));
                columnWidth[i] = Math.max(columnWidth[i], MarkdownTablePrinter.consoleWidth(s));
            }
        }
        if (!this.headerRendered) {
            int i;
            this.headerRendered = true;
            for (i = 0; i < columns; ++i) {
                this.writer.append('|');
                this.writer.append(MarkdownTablePrinter.align(this.fieldNames.get(i), columnWidth[i], this.alignments.get(i)));
            }
            this.writer.append("|\n");
            for (i = 0; i < columns; ++i) {
                this.writer.append("| ");
                this.writer.append("-".repeat(columnWidth[i]));
                this.writer.write(this.alignments.get(i) == Align.RIGHT ? 58 : 32);
            }
            this.writer.append("|\n");
        }
        for (List<?> row : rows) {
            for (int column = 0; column < columns; ++column) {
                this.writer.append('|');
                this.writer.append(MarkdownTablePrinter.align(MarkdownTablePrinter.formatValue(row.get(column)), columnWidth[column], this.alignments.get(column)));
            }
            this.writer.append("|\n");
        }
        this.writer.flush();
    }

    static String formatValue(Object o) {
        return FormatUtils.formatValue(o).replaceAll("([\\\\`*_{}\\[\\]<>()#+!|])", "\\\\$1").replace("\n", "<br>");
    }

    @Override
    public void finish() throws IOException {
        this.writer.flush();
    }

    private static String align(String value, int maxWidth, Align align) {
        int width = MarkdownTablePrinter.consoleWidth(value);
        Preconditions.checkState((width <= maxWidth ? 1 : 0) != 0, (String)"Variable width %s is greater than column width %s", (int)width, (int)maxWidth);
        String padding = " ".repeat(maxWidth - width + 1);
        return align == Align.RIGHT ? padding + value + " " : " " + value + padding;
    }

    static int consoleWidth(String value) {
        String plain = AttributedString.stripAnsi((String)value);
        int n = 0;
        for (int i = 0; i < plain.length(); ++i) {
            n += Math.max(WCWidth.wcwidth((int)plain.charAt(i)), 0);
        }
        return n;
    }

    private static enum Align {
        LEFT,
        RIGHT;

    }
}

