/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.cli.AbstractWarningsPrinter;
import io.trino.cli.AlignedTablePrinter;
import io.trino.cli.AutoTablePrinter;
import io.trino.cli.ClientOptions;
import io.trino.cli.CsvPrinter;
import io.trino.cli.JsonPrinter;
import io.trino.cli.MarkdownTablePrinter;
import io.trino.cli.NullPrinter;
import io.trino.cli.OutputHandler;
import io.trino.cli.OutputPrinter;
import io.trino.cli.Pager;
import io.trino.cli.QueryAbortedException;
import io.trino.cli.StatusPrinter;
import io.trino.cli.TerminalUtils;
import io.trino.cli.ThreadInterruptor;
import io.trino.cli.TsvPrinter;
import io.trino.cli.VerticalRecordPrinter;
import io.trino.cli.WarningsPrinter;
import io.trino.client.ClientSelectedRole;
import io.trino.client.Column;
import io.trino.client.ErrorLocation;
import io.trino.client.QueryError;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Query
implements Closeable {
    private static final Logger log = Logger.getLogger(Query.class.getName());
    private final AtomicBoolean ignoreUserInterrupt = new AtomicBoolean();
    private final StatementClient client;
    private final boolean debug;

    public Query(StatementClient client, boolean debug) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.debug = debug;
    }

    public Optional<String> getSetCatalog() {
        return this.client.getSetCatalog();
    }

    public Optional<String> getSetSchema() {
        return this.client.getSetSchema();
    }

    public Optional<List<String>> getSetPath() {
        return this.client.getSetPath();
    }

    public Optional<String> getSetAuthorizationUser() {
        return this.client.getSetAuthorizationUser();
    }

    public boolean isResetAuthorizationUser() {
        return this.client.isResetAuthorizationUser();
    }

    public Map<String, String> getSetSessionProperties() {
        return this.client.getSetSessionProperties();
    }

    public Set<String> getResetSessionProperties() {
        return this.client.getResetSessionProperties();
    }

    public Map<String, ClientSelectedRole> getSetRoles() {
        return this.client.getSetRoles();
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.client.getAddedPreparedStatements();
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.client.getDeallocatedPreparedStatements();
    }

    public String getStartedTransactionId() {
        return this.client.getStartedTransactionId();
    }

    public boolean isClearTransactionId() {
        return this.client.isClearTransactionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderOutput(Terminal terminal, PrintStream out, PrintStream errorChannel, ClientOptions.OutputFormat outputFormat, Optional<String> pager, boolean showProgress, boolean decimalDataSize) {
        Thread clientThread = Thread.currentThread();
        Terminal.SignalHandler oldHandler = terminal.handle(Terminal.Signal.INT, signal -> {
            if (this.ignoreUserInterrupt.get() || this.client.isClientAborted()) {
                return;
            }
            this.client.close();
            clientThread.interrupt();
        });
        try {
            boolean bl = this.renderQueryOutput(terminal, out, errorChannel, outputFormat, pager, showProgress, decimalDataSize);
            return bl;
        }
        finally {
            terminal.handle(Terminal.Signal.INT, oldHandler);
            Thread.interrupted();
        }
    }

    private boolean renderQueryOutput(Terminal terminal, PrintStream out, PrintStream errorChannel, ClientOptions.OutputFormat outputFormat, Optional<String> pager, boolean showProgress, boolean decimalDataSize) {
        StatusPrinter statusPrinter = null;
        PrintStreamWarningsPrinter warningsPrinter = new PrintStreamWarningsPrinter(errorChannel);
        if (showProgress) {
            statusPrinter = new StatusPrinter(this.client, errorChannel, this.debug, this.isInteractive(pager), decimalDataSize);
            statusPrinter.printInitialStatusUpdates(terminal);
        } else {
            this.processInitialStatusUpdates(warningsPrinter);
        }
        if (this.client.isRunning() || this.client.isFinished() && this.client.finalStatusInfo().getError() == null) {
            QueryStatusInfo results;
            QueryStatusInfo queryStatusInfo = results = this.client.isRunning() ? this.client.currentStatusInfo() : this.client.finalStatusInfo();
            if (results.getUpdateType() != null) {
                this.renderUpdate(terminal, errorChannel, results, outputFormat, pager);
            } else {
                if (results.getColumns() == null) {
                    errorChannel.printf("Query %s has no columns\n", results.getId());
                    return false;
                }
                this.renderResults(terminal, out, outputFormat, pager, results.getColumns());
            }
        }
        Preconditions.checkState((!this.client.isRunning() ? 1 : 0) != 0);
        warningsPrinter.print(this.client.finalStatusInfo().getWarnings(), true, true);
        if (showProgress) {
            statusPrinter.printFinalInfo();
        }
        if (this.client.isClientAborted()) {
            errorChannel.println("Query aborted by user");
            return false;
        }
        if (this.client.isClientError()) {
            errorChannel.println("Query is gone (server restarted?)");
            return false;
        }
        Verify.verify((boolean)this.client.isFinished());
        if (this.client.finalStatusInfo().getError() != null) {
            this.renderFailure(errorChannel);
            return false;
        }
        return true;
    }

    private boolean isInteractive(Optional<String> pager) {
        return pager.map(name -> !name.trim().isEmpty()).orElse(true);
    }

    private void processInitialStatusUpdates(WarningsPrinter warningsPrinter) {
        while (this.client.isRunning() && this.client.currentRows().isNull()) {
            warningsPrinter.print(this.client.currentStatusInfo().getWarnings(), true, false);
            try {
                this.client.advance();
            }
            catch (RuntimeException e) {
                log.log(Level.FINE, "error printing status", e);
            }
        }
        List warnings = this.client.isRunning() ? this.client.currentStatusInfo().getWarnings() : this.client.finalStatusInfo().getWarnings();
        warningsPrinter.print(warnings, false, true);
    }

    private void renderUpdate(Terminal terminal, PrintStream out, QueryStatusInfo results, ClientOptions.OutputFormat outputFormat, Optional<String> pager) {
        Object status = results.getUpdateType();
        if (results.getUpdateCount().isPresent()) {
            long count = results.getUpdateCount().getAsLong();
            status = (String)status + String.format(": %s row%s", count, count != 1L ? "s" : "");
            out.println((String)status);
        } else if (results.getColumns() != null && !results.getColumns().isEmpty()) {
            out.println((String)status);
            this.renderResults(terminal, out, outputFormat, pager, results.getColumns());
        } else {
            out.println((String)status);
        }
        this.discardResults();
    }

    private void discardResults() {
        try (OutputHandler handler = new OutputHandler(new NullPrinter());){
            handler.processRows(this.client);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void renderResults(Terminal terminal, PrintStream out, ClientOptions.OutputFormat outputFormat, Optional<String> pager, List<Column> columns) {
        try {
            this.doRenderResults(terminal, out, outputFormat, pager, columns);
        }
        catch (QueryAbortedException e) {
            System.out.println("(query aborted by user)");
            this.client.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doRenderResults(Terminal terminal, PrintStream out, ClientOptions.OutputFormat format, Optional<String> pager, List<Column> columns) throws IOException {
        if (this.isInteractive(pager)) {
            this.pageOutput(pager, format, terminal.getWidth(), columns);
        } else {
            this.sendOutput(out, format, terminal.getWidth(), columns);
        }
    }

    private void pageOutput(Optional<String> pagerName, ClientOptions.OutputFormat format, int maxWidth, List<Column> columns) throws IOException {
        try (Pager pager = Pager.create(pagerName);
             ThreadInterruptor clientThread = new ThreadInterruptor();
             Writer writer = Query.createWriter(pager);
             OutputHandler handler = Query.createOutputHandler(format, maxWidth, writer, columns);){
            if (!pager.isNullPager()) {
                this.ignoreUserInterrupt.set(true);
                pager.getFinishFuture().thenRun(() -> {
                    this.ignoreUserInterrupt.set(false);
                    this.client.close();
                    clientThread.interrupt();
                });
            }
            handler.processRows(this.client);
        }
        catch (IOException | RuntimeException e) {
            if (this.client.isClientAborted() && !(e instanceof QueryAbortedException)) {
                throw new QueryAbortedException(e);
            }
            throw e;
        }
    }

    private void sendOutput(PrintStream out, ClientOptions.OutputFormat format, int maxWidth, List<Column> fieldNames) throws IOException {
        try (OutputHandler handler = Query.createOutputHandler(format, maxWidth, Query.createWriter(out), fieldNames);){
            handler.processRows(this.client);
        }
    }

    private static OutputHandler createOutputHandler(ClientOptions.OutputFormat format, int maxWidth, Writer writer, List<Column> columns) {
        return new OutputHandler(Query.createOutputPrinter(format, maxWidth, writer, columns));
    }

    private static OutputPrinter createOutputPrinter(ClientOptions.OutputFormat format, int maxWidth, Writer writer, List<Column> columns) {
        List fieldNames = (List)columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        switch (format) {
            case AUTO: {
                return new AutoTablePrinter(columns, writer, maxWidth);
            }
            case ALIGNED: {
                return new AlignedTablePrinter(columns, writer);
            }
            case VERTICAL: {
                return new VerticalRecordPrinter(fieldNames, writer);
            }
            case CSV: {
                return new CsvPrinter(fieldNames, writer, CsvPrinter.CsvOutputFormat.NO_HEADER);
            }
            case CSV_HEADER: {
                return new CsvPrinter(fieldNames, writer, CsvPrinter.CsvOutputFormat.STANDARD);
            }
            case CSV_UNQUOTED: {
                return new CsvPrinter(fieldNames, writer, CsvPrinter.CsvOutputFormat.NO_HEADER_AND_QUOTES);
            }
            case CSV_HEADER_UNQUOTED: {
                return new CsvPrinter(fieldNames, writer, CsvPrinter.CsvOutputFormat.NO_QUOTES);
            }
            case TSV: {
                return new TsvPrinter(fieldNames, writer, false);
            }
            case TSV_HEADER: {
                return new TsvPrinter(fieldNames, writer, true);
            }
            case JSON: {
                return new JsonPrinter(fieldNames, writer);
            }
            case MARKDOWN: {
                return new MarkdownTablePrinter(columns, writer);
            }
            case NULL: {
                return new NullPrinter();
            }
        }
        throw new RuntimeException(String.valueOf((Object)format) + " not supported");
    }

    private static Writer createWriter(OutputStream out) {
        return new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 16384);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public void renderFailure(PrintStream out) {
        QueryStatusInfo results = this.client.finalStatusInfo();
        QueryError error = results.getError();
        Preconditions.checkState((error != null ? 1 : 0) != 0);
        out.printf("Query %s failed: %s%n", results.getId(), error.getMessage());
        if (this.debug && error.getFailureInfo() != null) {
            error.getFailureInfo().toException().printStackTrace(out);
        }
        if (error.getErrorLocation() != null) {
            Query.renderErrorLocation(this.client.getQuery(), error.getErrorLocation(), out);
        }
        out.println();
    }

    private static void renderErrorLocation(String query, ErrorLocation location, PrintStream out) {
        ImmutableList lines = ImmutableList.copyOf(Splitter.on((char)'\n').split((CharSequence)query).iterator());
        String errorLine = (String)lines.get(location.getLineNumber() - 1);
        String good = errorLine.substring(0, location.getColumnNumber() - 1);
        String bad = errorLine.substring(location.getColumnNumber() - 1);
        if (location.getLineNumber() == lines.size() && bad.trim().isEmpty()) {
            bad = " <EOF>";
        }
        if (TerminalUtils.isRealTerminal()) {
            int i;
            AttributedStringBuilder builder = new AttributedStringBuilder();
            builder.style(AttributedStyle.DEFAULT.foreground(6));
            for (i = 1; i < location.getLineNumber(); ++i) {
                builder.append((CharSequence)lines.get(i - 1)).append((CharSequence)"\n");
            }
            builder.append((CharSequence)good);
            builder.style(AttributedStyle.DEFAULT.foreground(1));
            builder.append((CharSequence)bad).append((CharSequence)"\n");
            for (i = location.getLineNumber(); i < lines.size(); ++i) {
                builder.append((CharSequence)lines.get(i)).append((CharSequence)"\n");
            }
            builder.style(AttributedStyle.DEFAULT);
            out.print(builder.toAnsi());
        } else {
            String prefix = String.format("LINE %s: ", location.getLineNumber());
            String padding = Strings.repeat((String)" ", (int)(prefix.length() + (location.getColumnNumber() - 1)));
            out.println(prefix + errorLine);
            out.println(padding + "^");
        }
    }

    private static class PrintStreamWarningsPrinter
    extends AbstractWarningsPrinter {
        private final PrintStream printStream;

        PrintStreamWarningsPrinter(PrintStream printStream) {
            super(OptionalInt.empty());
            this.printStream = Objects.requireNonNull(printStream, "printStream is null");
        }

        @Override
        protected void print(List<String> warnings) {
            warnings.forEach(this.printStream::println);
        }

        @Override
        protected void printSeparator() {
            this.printStream.println();
        }
    }
}

