/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import io.trino.cli.AlignedTablePrinter;
import io.trino.cli.OutputPrinter;
import io.trino.cli.VerticalRecordPrinter;
import io.trino.client.Column;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;

public class AutoTablePrinter
implements OutputPrinter {
    private final int maxWidth;
    private OutputPrinter delegate;
    private final OutputPrinter fallback;
    private final StringWriter bufferWriter = new StringWriter();
    private final Writer writer;

    public AutoTablePrinter(List<Column> columns, Writer writer, int maxWidth) {
        Objects.requireNonNull(columns, "columns is null");
        this.writer = Objects.requireNonNull(writer, "writer is null");
        this.maxWidth = maxWidth;
        this.delegate = new AlignedTablePrinter(columns, this.bufferWriter);
        List fieldNames = (List)columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        this.fallback = new VerticalRecordPrinter(fieldNames, this.bufferWriter);
    }

    @Override
    public void finish() throws IOException {
        this.delegate.finish();
        this.flush();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        this.delegate.printRows(rows, complete);
        if (!this.delegate.equals(this.fallback) && this.bufferWriter.toString().indexOf("\n") > this.maxWidth) {
            this.delegate = this.fallback;
            this.bufferWriter.getBuffer().setLength(0);
            this.delegate.printRows(rows, complete);
        }
        this.flush();
    }

    private void flush() throws IOException {
        this.writer.write(this.bufferWriter.toString());
        this.writer.flush();
        this.bufferWriter.getBuffer().setLength(0);
    }
}

