/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import io.trino.cli.Query;
import io.trino.client.ClientSession;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.uri.HttpClientFactory;
import io.trino.client.uri.TrinoUri;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class QueryRunner
implements Closeable {
    private final AtomicReference<ClientSession> session;
    private final boolean debug;
    private final OkHttpClient httpClient;
    private final OkHttpClient segmentHttpClient;

    public QueryRunner(TrinoUri uri, ClientSession session, boolean debug) {
        this.session = new AtomicReference<ClientSession>(Objects.requireNonNull(session, "session is null"));
        this.httpClient = HttpClientFactory.toHttpClientBuilder((TrinoUri)uri, (String)session.getSource()).build();
        this.segmentHttpClient = HttpClientFactory.unauthenticatedClientBuilder((TrinoUri)uri, (String)session.getSource()).build();
        this.debug = debug;
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set(Objects.requireNonNull(session, "session is null"));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(this.session.get(), query), this.debug);
    }

    public StatementClient startInternalQuery(String query) {
        return this.startInternalQuery(ClientSession.stripTransactionId((ClientSession)this.session.get()), query);
    }

    private StatementClient startInternalQuery(ClientSession session, String query) {
        return StatementClientFactory.newStatementClient((Call.Factory)this.httpClient, (Call.Factory)this.segmentHttpClient, (ClientSession)session, (String)query);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

